% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_get_studio_session_mapping}
\alias{emr_get_studio_session_mapping}
\title{The Amazon EMR Studio APIs are in preview release for Amazon EMR and are
subject to change}
\usage{
emr_get_studio_session_mapping(StudioId, IdentityId, IdentityName,
  IdentityType)
}
\arguments{
\item{StudioId}{[required] The ID of the Amazon EMR Studio.}

\item{IdentityId}{The globally unique identifier (GUID) of the user or group. For more
information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId}{UserId}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId}{GroupId}
in the \emph{AWS SSO Identity Store API Reference}. Either \code{IdentityName} or
\code{IdentityId} must be specified.}

\item{IdentityName}{The name of the user or group to fetch. For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId}{UserName}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName}{DisplayName}
in the \emph{AWS SSO Identity Store API Reference}. Either \code{IdentityName} or
\code{IdentityId} must be specified.}

\item{IdentityType}{[required] Specifies whether the identity to fetch is a user or a group.}
}
\description{
The Amazon EMR Studio APIs are in preview release for Amazon EMR and are
subject to change.

Fetches mapping details for the specified Amazon EMR Studio and identity
(user or group).
}
\section{Request syntax}{
\preformatted{svc$get_studio_session_mapping(
  StudioId = "string",
  IdentityId = "string",
  IdentityName = "string",
  IdentityType = "USER"|"GROUP"
)
}
}

\keyword{internal}
