% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_connection}
\alias{glue_create_connection}
\title{Creates a connection definition in the Data Catalog}
\usage{
glue_create_connection(CatalogId, ConnectionInput)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog in which to create the connection. If none is
provided, the AWS account ID is used by default.}

\item{ConnectionInput}{[required] A \code{ConnectionInput} object defining the connection to create.}
}
\description{
Creates a connection definition in the Data Catalog.
}
\section{Request syntax}{
\preformatted{svc$create_connection(
  CatalogId = "string",
  ConnectionInput = list(
    Name = "string",
    Description = "string",
    ConnectionType = "JDBC"|"SFTP"|"MONGODB"|"KAFKA"|"NETWORK"|"MARKETPLACE"|"CUSTOM",
    MatchCriteria = list(
      "string"
    ),
    ConnectionProperties = list(
      "string"
    ),
    PhysicalConnectionRequirements = list(
      SubnetId = "string",
      SecurityGroupIdList = list(
        "string"
      ),
      AvailabilityZone = "string"
    )
  )
)
}
}

\keyword{internal}
