% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_schema}
\alias{glue_create_schema}
\title{Creates a new schema set and registers the schema definition}
\usage{
glue_create_schema(RegistryId, SchemaName, DataFormat, Compatibility,
  Description, Tags, SchemaDefinition)
}
\arguments{
\item{RegistryId}{This is a wrapper shape to contain the registry identity fields. If this
is not provided, the default registry will be used. The ARN format for
the same will be:
\verb{arn:aws:glue:us-east-2:<customer id>:registry/default-registry:random-5-letter-id}.}

\item{SchemaName}{[required] Name of the schema to be created of max length of 255, and may only
contain letters, numbers, hyphen, underscore, dollar sign, or hash mark.
No whitespace.}

\item{DataFormat}{[required] The data format of the schema definition. Currently only \code{AVRO} is
supported.}

\item{Compatibility}{The compatibility mode of the schema. The possible values are:
\itemize{
\item \emph{NONE}: No compatibility mode applies. You can use this choice in
development scenarios or if you do not know the compatibility mode
that you want to apply to schemas. Any new version added will be
accepted without undergoing a compatibility check.
\item \emph{DISABLED}: This compatibility choice prevents versioning for a
particular schema. You can use this choice to prevent future
versioning of a schema.
\item \emph{BACKWARD}: This compatibility choice is recommended as it allows
data receivers to read both the current and one previous schema
version. This means that for instance, a new schema version cannot
drop data fields or change the type of these fields, so they can't
be read by readers using the previous version.
\item \emph{BACKWARD_ALL}: This compatibility choice allows data receivers to
read both the current and all previous schema versions. You can use
this choice when you need to delete fields or add optional fields,
and check compatibility against all previous schema versions.
\item \emph{FORWARD}: This compatibility choice allows data receivers to read
both the current and one next schema version, but not necessarily
later versions. You can use this choice when you need to add fields
or delete optional fields, but only check compatibility against the
last schema version.
\item \emph{FORWARD_ALL}: This compatibility choice allows data receivers to
read written by producers of any new registered schema. You can use
this choice when you need to add fields or delete optional fields,
and check compatibility against all previous schema versions.
\item \emph{FULL}: This compatibility choice allows data receivers to read data
written by producers using the previous or next version of the
schema, but not necessarily earlier or later versions. You can use
this choice when you need to add or remove optional fields, but only
check compatibility against the last schema version.
\item \emph{FULL_ALL}: This compatibility choice allows data receivers to read
data written by producers using all previous schema versions. You
can use this choice when you need to add or remove optional fields,
and check compatibility against all previous schema versions.
}}

\item{Description}{An optional description of the schema. If description is not provided,
there will not be any automatic default value for this.}

\item{Tags}{AWS tags that contain a key value pair and may be searched by console,
command line, or API. If specified, follows the AWS tags-on-create
pattern.}

\item{SchemaDefinition}{The schema definition using the \code{DataFormat} setting for \code{SchemaName}.}
}
\value{
A list with the following syntax:\preformatted{list(
  RegistryName = "string",
  RegistryArn = "string",
  SchemaName = "string",
  SchemaArn = "string",
  Description = "string",
  DataFormat = "AVRO",
  Compatibility = "NONE"|"DISABLED"|"BACKWARD"|"BACKWARD_ALL"|"FORWARD"|"FORWARD_ALL"|"FULL"|"FULL_ALL",
  SchemaCheckpoint = 123,
  LatestSchemaVersion = 123,
  NextSchemaVersion = 123,
  SchemaStatus = "AVAILABLE"|"PENDING"|"DELETING",
  Tags = list(
    "string"
  ),
  SchemaVersionId = "string",
  SchemaVersionStatus = "AVAILABLE"|"PENDING"|"FAILURE"|"DELETING"
)
}
}
\description{
Creates a new schema set and registers the schema definition. Returns an
error if the schema set already exists without actually registering the
version.

When the schema set is created, a version checkpoint will be set to the
first version. Compatibility mode "DISABLED" restricts any additional
schema versions from being added after the first schema version. For all
other compatibility modes, validation of compatibility settings will be
applied only from the second version onwards when the
\code{\link[=glue_register_schema_version]{register_schema_version}} API is used.

When this API is called without a \code{RegistryId}, this will create an
entry for a "default-registry" in the registry database tables, if it is
not already present.
}
\section{Request syntax}{
\preformatted{svc$create_schema(
  RegistryId = list(
    RegistryName = "string",
    RegistryArn = "string"
  ),
  SchemaName = "string",
  DataFormat = "AVRO",
  Compatibility = "NONE"|"DISABLED"|"BACKWARD"|"BACKWARD_ALL"|"FORWARD"|"FORWARD_ALL"|"FULL"|"FULL_ALL",
  Description = "string",
  Tags = list(
    "string"
  ),
  SchemaDefinition = "string"
)
}
}

\keyword{internal}
