% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_dev_endpoints}
\alias{glue_get_dev_endpoints}
\title{Retrieves all the development endpoints in this AWS account}
\usage{
glue_get_dev_endpoints(MaxResults, NextToken)
}
\arguments{
\item{MaxResults}{The maximum size of information to return.}

\item{NextToken}{A continuation token, if this is a continuation call.}
}
\value{
A list with the following syntax:\preformatted{list(
  DevEndpoints = list(
    list(
      EndpointName = "string",
      RoleArn = "string",
      SecurityGroupIds = list(
        "string"
      ),
      SubnetId = "string",
      YarnEndpointAddress = "string",
      PrivateAddress = "string",
      ZeppelinRemoteSparkInterpreterPort = 123,
      PublicAddress = "string",
      Status = "string",
      WorkerType = "Standard"|"G.1X"|"G.2X",
      GlueVersion = "string",
      NumberOfWorkers = 123,
      NumberOfNodes = 123,
      AvailabilityZone = "string",
      VpcId = "string",
      ExtraPythonLibsS3Path = "string",
      ExtraJarsS3Path = "string",
      FailureReason = "string",
      LastUpdateStatus = "string",
      CreatedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      LastModifiedTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      PublicKey = "string",
      PublicKeys = list(
        "string"
      ),
      SecurityConfiguration = "string",
      Arguments = list(
        "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves all the development endpoints in this AWS account.

When you create a development endpoint in a virtual private cloud (VPC),
AWS Glue returns only a private IP address and the public IP address
field is not populated. When you create a non-VPC development endpoint,
AWS Glue returns only a public IP address.
}
\section{Request syntax}{
\preformatted{svc$get_dev_endpoints(
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
