% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_table_version}
\alias{glue_get_table_version}
\title{Retrieves a specified version of a table}
\usage{
glue_get_table_version(CatalogId, DatabaseName, TableName, VersionId)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the tables reside. If none is provided,
the AWS account ID is used by default.}

\item{DatabaseName}{[required] The database in the catalog in which the table resides. For Hive
compatibility, this name is entirely lowercase.}

\item{TableName}{[required] The name of the table. For Hive compatibility, this name is entirely
lowercase.}

\item{VersionId}{The ID value of the table version to be retrieved. A \code{VersionID} is a
string representation of an integer. Each version is incremented by 1.}
}
\value{
A list with the following syntax:\preformatted{list(
  TableVersion = list(
    Table = list(
      Name = "string",
      DatabaseName = "string",
      Description = "string",
      Owner = "string",
      CreateTime = as.POSIXct(
        "2015-01-01"
      ),
      UpdateTime = as.POSIXct(
        "2015-01-01"
      ),
      LastAccessTime = as.POSIXct(
        "2015-01-01"
      ),
      LastAnalyzedTime = as.POSIXct(
        "2015-01-01"
      ),
      Retention = 123,
      StorageDescriptor = list(
        Columns = list(
          list(
            Name = "string",
            Type = "string",
            Comment = "string",
            Parameters = list(
              "string"
            )
          )
        ),
        Location = "string",
        InputFormat = "string",
        OutputFormat = "string",
        Compressed = TRUE|FALSE,
        NumberOfBuckets = 123,
        SerdeInfo = list(
          Name = "string",
          SerializationLibrary = "string",
          Parameters = list(
            "string"
          )
        ),
        BucketColumns = list(
          "string"
        ),
        SortColumns = list(
          list(
            Column = "string",
            SortOrder = 123
          )
        ),
        Parameters = list(
          "string"
        ),
        SkewedInfo = list(
          SkewedColumnNames = list(
            "string"
          ),
          SkewedColumnValues = list(
            "string"
          ),
          SkewedColumnValueLocationMaps = list(
            "string"
          )
        ),
        StoredAsSubDirectories = TRUE|FALSE,
        SchemaReference = list(
          SchemaId = list(
            SchemaArn = "string",
            SchemaName = "string",
            RegistryName = "string"
          ),
          SchemaVersionId = "string",
          SchemaVersionNumber = 123
        )
      ),
      PartitionKeys = list(
        list(
          Name = "string",
          Type = "string",
          Comment = "string",
          Parameters = list(
            "string"
          )
        )
      ),
      ViewOriginalText = "string",
      ViewExpandedText = "string",
      TableType = "string",
      Parameters = list(
        "string"
      ),
      CreatedBy = "string",
      IsRegisteredWithLakeFormation = TRUE|FALSE,
      TargetTable = list(
        CatalogId = "string",
        DatabaseName = "string",
        Name = "string"
      ),
      CatalogId = "string"
    ),
    VersionId = "string"
  )
)
}
}
\description{
Retrieves a specified version of a table.
}
\section{Request syntax}{
\preformatted{svc$get_table_version(
  CatalogId = "string",
  DatabaseName = "string",
  TableName = "string",
  VersionId = "string"
)
}
}

\keyword{internal}
