% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_job_run}
\alias{glue_get_job_run}
\title{Retrieves the metadata for a given job run}
\usage{
glue_get_job_run(JobName, RunId, PredecessorsIncluded)
}
\arguments{
\item{JobName}{[required] Name of the job definition being run.}

\item{RunId}{[required] The ID of the job run.}

\item{PredecessorsIncluded}{True if a list of predecessor runs should be returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  JobRun = list(
    Id = "string",
    Attempt = 123,
    PreviousRunId = "string",
    TriggerName = "string",
    JobName = "string",
    StartedOn = as.POSIXct(
      "2015-01-01"
    ),
    LastModifiedOn = as.POSIXct(
      "2015-01-01"
    ),
    CompletedOn = as.POSIXct(
      "2015-01-01"
    ),
    JobRunState = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT",
    Arguments = list(
      "string"
    ),
    ErrorMessage = "string",
    PredecessorRuns = list(
      list(
        JobName = "string",
        RunId = "string"
      )
    ),
    AllocatedCapacity = 123,
    ExecutionTime = 123,
    Timeout = 123,
    MaxCapacity = 123.0,
    WorkerType = "Standard"|"G.1X"|"G.2X",
    NumberOfWorkers = 123,
    SecurityConfiguration = "string",
    LogGroupName = "string",
    NotificationProperty = list(
      NotifyDelayAfter = 123
    ),
    GlueVersion = "string"
  )
)
}
}
\description{
Retrieves the metadata for a given job run.
}
\section{Request syntax}{
\preformatted{svc$get_job_run(
  JobName = "string",
  RunId = "string",
  PredecessorsIncluded = TRUE|FALSE
)
}
}

\keyword{internal}
