% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_increase_stream_retention_period}
\alias{kinesis_increase_stream_retention_period}
\title{Increases the Kinesis data stream's retention period, which is the
length of time data records are accessible after they are added to the
stream}
\usage{
kinesis_increase_stream_retention_period(StreamName,
  RetentionPeriodHours)
}
\arguments{
\item{StreamName}{[required] The name of the stream to modify.}

\item{RetentionPeriodHours}{[required] The new retention period of the stream, in hours. Must be more than the
current retention period.}
}
\value{
An empty list.
}
\description{
Increases the Kinesis data stream's retention period, which is the
length of time data records are accessible after they are added to the
stream. The maximum value of a stream's retention period is 168 hours (7
days).

If you choose a longer stream retention period, this operation increases
the time period during which records that have not yet expired are
accessible. However, it does not make previous, expired data (older than
the stream's previous retention period) accessible after the operation
has been called. For example, if a stream's retention period is set to
24 hours and is increased to 168 hours, any data that is older than 24
hours remains inaccessible to consumer applications.
}
\section{Request syntax}{
\preformatted{svc$increase_stream_retention_period(
  StreamName = "string",
  RetentionPeriodHours = 123
)
}
}

\keyword{internal}
