% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_remove_tags}
\alias{emr_remove_tags}
\title{Removes tags from an Amazon EMR resource}
\usage{
emr_remove_tags(ResourceId, TagKeys)
}
\arguments{
\item{ResourceId}{[required] The Amazon EMR resource identifier from which tags will be removed. This
value must be a cluster identifier.}

\item{TagKeys}{[required] A list of tag keys to remove from a resource.}
}
\description{
Removes tags from an Amazon EMR resource. Tags make it easier to
associate clusters in various ways, such as grouping clusters to track
your Amazon EMR resource allocation costs. For more information, see
\href{https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html}{Tag Clusters}.
}
\details{
The following example removes the stack tag with value Prod from a
cluster:
}
\section{Request syntax}{
\preformatted{svc$remove_tags(
  ResourceId = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
