% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_put_record_batch}
\alias{firehose_put_record_batch}
\title{Writes multiple data records into a delivery stream in a single call,
which can achieve higher throughput per producer than when writing
single records}
\usage{
firehose_put_record_batch(DeliveryStreamName, Records)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream.}

\item{Records}{[required] One or more records.}
}
\description{
Writes multiple data records into a delivery stream in a single call,
which can achieve higher throughput per producer than when writing
single records. To write single data records into a delivery stream, use
PutRecord. Applications using these operations are referred to as
producers.
}
\details{
By default, each delivery stream can take in up to 2,000 transactions
per second, 5,000 records per second, or 5 MB per second. If you use
PutRecord and PutRecordBatch, the limits are an aggregate across these
two operations for each delivery stream. For more information about
limits, see \href{http://docs.aws.amazon.com/firehose/latest/dev/limits.html}{Amazon Kinesis Data Firehose Limits}.

Each PutRecordBatch request supports up to 500 records. Each record in
the request can be as large as 1,000 KB (before 64-bit encoding), up to
a limit of 4 MB for the entire request. These limits cannot be changed.

You must specify the name of the delivery stream and the data record
when using PutRecord. The data record consists of a data blob that can
be up to 1,000 KB in size, and any kind of data. For example, it could
be a segment from a log file, geographic location data, website
clickstream data, and so on.

Kinesis Data Firehose buffers records before delivering them to the
destination. To disambiguate the data blobs at the destination, a common
solution is to use delimiters in the data, such as a newline (\code{\\n}) or
some other character unique within the data. This allows the consumer
application to parse individual data items when reading the data from
the destination.

The PutRecordBatch response includes a count of failed records,
\code{FailedPutCount}, and an array of responses, \code{RequestResponses}. Even if
the PutRecordBatch call succeeds, the value of \code{FailedPutCount} may be
greater than 0, indicating that there are records for which the
operation didn't succeed. Each entry in the \code{RequestResponses} array
provides additional information about the processed record. It directly
correlates with a record in the request array using the same ordering,
from the top to the bottom. The response array always includes the same
number of records as the request array. \code{RequestResponses} includes both
successfully and unsuccessfully processed records. Kinesis Data Firehose
tries to process all records in each PutRecordBatch request. A single
record failure does not stop the processing of subsequent records.

A successfully processed record includes a \code{RecordId} value, which is
unique for the record. An unsuccessfully processed record includes
\code{ErrorCode} and \code{ErrorMessage} values. \code{ErrorCode} reflects the type of
error, and is one of the following values: \code{ServiceUnavailableException}
or \code{InternalFailure}. \code{ErrorMessage} provides more detailed information
about the error.

If there is an internal server error or a timeout, the write might have
completed or it might have failed. If \code{FailedPutCount} is greater than
0, retry the request, resending only those records that might have
failed processing. This minimizes the possible duplicate records and
also reduces the total bytes sent (and corresponding charges). We
recommend that you handle any duplicates at the destination.

If PutRecordBatch throws \code{ServiceUnavailableException}, back off and
retry. If the exception persists, it is possible that the throughput
limits have been exceeded for the delivery stream.

Data records sent to Kinesis Data Firehose are stored for 24 hours from
the time they are added to a delivery stream as it attempts to send the
records to the destination. If the destination is unreachable for more
than 24 hours, the data is no longer available.

Don't concatenate two or more base64 strings to form the data fields of
your records. Instead, concatenate the raw data, then perform base64
encoding.
}
\section{Request syntax}{
\preformatted{svc$put_record_batch(
  DeliveryStreamName = "string",
  Records = list(
    list(
      Data = raw
    )
  )
)
}
}

\keyword{internal}
