% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_discover_input_schema}
\alias{kinesisanalyticsv2_discover_input_schema}
\title{Infers a schema for an SQL-based Amazon Kinesis Data Analytics
application by evaluating sample records on the specified streaming
source (Kinesis data stream or Kinesis Data Firehose delivery stream) or
Amazon S3 object}
\usage{
kinesisanalyticsv2_discover_input_schema(ResourceARN,
  ServiceExecutionRole, InputStartingPositionConfiguration,
  S3Configuration, InputProcessingConfiguration)
}
\arguments{
\item{ResourceARN}{The Amazon Resource Name (ARN) of the streaming source.}

\item{ServiceExecutionRole}{[required] The ARN of the role that is used to access the streaming source.}

\item{InputStartingPositionConfiguration}{The point at which you want Kinesis Data Analytics to start reading
records from the specified streaming source discovery purposes.}

\item{S3Configuration}{Specify this parameter to discover a schema from data in an Amazon S3
object.}

\item{InputProcessingConfiguration}{The InputProcessingConfiguration to use to preprocess the records before
discovering the schema of the records.}
}
\description{
Infers a schema for an SQL-based Amazon Kinesis Data Analytics
application by evaluating sample records on the specified streaming
source (Kinesis data stream or Kinesis Data Firehose delivery stream) or
Amazon S3 object. In the response, the operation returns the inferred
schema and also the sample records that the operation used to infer the
schema.
}
\details{
You can use the inferred schema when configuring a streaming source for
your application. When you create an application using the Kinesis Data
Analytics console, the console uses this operation to infer a schema and
show it in the console user interface.
}
\section{Request syntax}{
\preformatted{svc$discover_input_schema(
  ResourceARN = "string",
  ServiceExecutionRole = "string",
  InputStartingPositionConfiguration = list(
    InputStartingPosition = "NOW"|"TRIM_HORIZON"|"LAST_STOPPED_POINT"
  ),
  S3Configuration = list(
    BucketARN = "string",
    FileKey = "string"
  ),
  InputProcessingConfiguration = list(
    InputLambdaProcessor = list(
      ResourceARN = "string"
    )
  )
)
}
}

\keyword{internal}
