% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_schema_by_definition}
\alias{glue_get_schema_by_definition}
\title{Retrieves a schema by the SchemaDefinition}
\usage{
glue_get_schema_by_definition(SchemaId, SchemaDefinition)
}
\arguments{
\item{SchemaId}{[required] This is a wrapper structure to contain schema identity fields. The
structure contains:
\itemize{
\item SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
One of \code{SchemaArn} or \code{SchemaName} has to be provided.
\item SchemaId$SchemaName: The name of the schema. One of \code{SchemaArn} or
\code{SchemaName} has to be provided.
}}

\item{SchemaDefinition}{[required] The definition of the schema for which schema details are required.}
}
\description{
Retrieves a schema by the \code{SchemaDefinition}. The schema definition is sent to the Schema Registry, canonicalized, and hashed. If the hash is matched within the scope of the \code{SchemaName} or ARN (or the default registry, if none is supplied), that schema’s metadata is returned. Otherwise, a 404 or NotFound error is returned. Schema versions in \code{Deleted} statuses will not be included in the results.

See \url{https://www.paws-r-sdk.com/docs/glue_get_schema_by_definition/} for full documentation.
}
\keyword{internal}
