% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_split_shard}
\alias{kinesis_split_shard}
\title{Splits a shard into two new shards in the Kinesis data stream, to
increase the stream's capacity to ingest and transport data}
\usage{
kinesis_split_shard(
  StreamName = NULL,
  ShardToSplit,
  NewStartingHashKey,
  StreamARN = NULL
)
}
\arguments{
\item{StreamName}{The name of the stream for the shard split.}

\item{ShardToSplit}{[required] The shard ID of the shard to split.}

\item{NewStartingHashKey}{[required] A hash key value for the starting hash key of one of the child shards
created by the split. The hash key range for a given shard constitutes a
set of ordered contiguous positive integers. The value for
\code{NewStartingHashKey} must be in the range of hash keys being mapped into
the shard. The \code{NewStartingHashKey} hash key value and all higher hash
key values in hash key range are distributed to one of the child shards.
All the lower hash key values in the range are distributed to the other
child shard.}

\item{StreamARN}{The ARN of the stream.}
}
\description{
Splits a shard into two new shards in the Kinesis data stream, to increase the stream's capacity to ingest and transport data. \code{\link[=kinesis_split_shard]{split_shard}} is called when there is a need to increase the overall capacity of a stream because of an expected increase in the volume of data records being ingested. This API is only supported for the data streams with the provisioned capacity mode.

See \url{https://www.paws-r-sdk.com/docs/kinesis_split_shard/} for full documentation.
}
\keyword{internal}
