% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivs_operations.R
\name{ivs_create_playback_restriction_policy}
\alias{ivs_create_playback_restriction_policy}
\title{Creates a new playback restriction policy, for constraining playback by
countries and/or origins}
\usage{
ivs_create_playback_restriction_policy(
  allowedCountries = NULL,
  allowedOrigins = NULL,
  enableStrictOriginEnforcement = NULL,
  name = NULL,
  tags = NULL
)
}
\arguments{
\item{allowedCountries}{A list of country codes that control geoblocking restriction. Allowed
values are the officially assigned \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2} codes.
Default: All countries (an empty array).}

\item{allowedOrigins}{A list of origin sites that control CORS restriction. Allowed values are
the same as valid values of the Origin header defined at
\url{https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin}.
Default: All origins (an empty array).}

\item{enableStrictOriginEnforcement}{Whether channel playback is constrained by origin site. Default:
\code{false}.}

\item{name}{Playback-restriction-policy name. The value does not need to be unique.}

\item{tags}{Array of 1-50 maps, each of the form \code{string:string (key:value)}. See
\href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services Resources}
for more information, including restrictions that apply to tags and "Tag
naming limits and requirements"; Amazon IVS has no service-specific
constraints beyond what is documented there.}
}
\description{
Creates a new playback restriction policy, for constraining playback by countries and/or origins.

See \url{https://www.paws-r-sdk.com/docs/ivs_create_playback_restriction_policy/} for full documentation.
}
\keyword{internal}
