% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_list_endpoints_by_platform_application}
\alias{sns_list_endpoints_by_platform_application}
\title{Lists the endpoints and endpoint attributes for devices in a supported
push notification service, such as GCM and APNS}
\usage{
sns_list_endpoints_by_platform_application(PlatformApplicationArn,
  NextToken)
}
\arguments{
\item{PlatformApplicationArn}{[required] PlatformApplicationArn for ListEndpointsByPlatformApplicationInput
action.}

\item{NextToken}{NextToken string is used when calling ListEndpointsByPlatformApplication
action to retrieve additional records that are available after the first
page results.}
}
\description{
Lists the endpoints and endpoint attributes for devices in a supported
push notification service, such as GCM and APNS. The results for
\code{ListEndpointsByPlatformApplication} are paginated and return a limited
list of endpoints, up to 100. If additional records are available after
the first page results, then a NextToken string will be returned. To
receive the next page, you call \code{ListEndpointsByPlatformApplication}
again using the NextToken string received from the previous call. When
there are no more records to return, NextToken will be null. For more
information, see \href{http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html}{Using Amazon SNS Mobile Push Notifications}.
}
\details{
This action is throttled at 30 transactions per second (TPS).
}
\section{Request syntax}{
\preformatted{svc$list_endpoints_by_platform_application(
  PlatformApplicationArn = "string",
  NextToken = "string"
)
}
}

\keyword{internal}
