% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_set_sms_attributes}
\alias{sns_set_sms_attributes}
\title{Use this request to set the default settings for sending SMS messages
and receiving daily SMS usage reports}
\usage{
sns_set_sms_attributes(attributes)
}
\arguments{
\item{attributes}{[required] The default settings for sending SMS messages from your account. You can
set values for the following attribute names:

\code{MonthlySpendLimit} – The maximum amount in USD that you are willing to
spend each month to send SMS messages. When Amazon SNS determines that
sending an SMS message would incur a cost that exceeds this limit, it
stops sending SMS messages within minutes.

Amazon SNS stops sending SMS messages within minutes of the limit being
crossed. During that interval, if you continue to send SMS messages, you
will incur costs that exceed your limit.

By default, the spend limit is set to the maximum allowed by Amazon SNS.
If you want to raise the limit, submit an SNS Limit Increase case. For
\strong{New limit value}, enter your desired monthly spend limit. In the
\strong{Use Case Description} field, explain that you are requesting an SMS
monthly spend limit increase.

\code{DeliveryStatusIAMRole} – The ARN of the IAM role that allows Amazon SNS
to write logs about SMS deliveries in CloudWatch Logs. For each SMS
message that you send, Amazon SNS writes a log that includes the message
price, the success or failure status, the reason for failure (if the
message failed), the message dwell time, and other information.

\code{DeliveryStatusSuccessSamplingRate} – The percentage of successful SMS
deliveries for which Amazon SNS will write logs in CloudWatch Logs. The
value can be an integer from 0 - 100. For example, to write logs only
for failed deliveries, set this value to \code{0}. To write logs for 10\\% of
your successful deliveries, set it to \code{10}.

\code{DefaultSenderID} – A string, such as your business brand, that is
displayed as the sender on the receiving device. Support for sender IDs
varies by country. The sender ID can be 1 - 11 alphanumeric characters,
and it must contain at least one letter.

\code{DefaultSMSType} – The type of SMS message that you will send by
default. You can assign the following values:
\itemize{
\item \code{Promotional} – (Default) Noncritical messages, such as marketing
messages. Amazon SNS optimizes the message delivery to incur the
lowest cost.
\item \code{Transactional} – Critical messages that support customer
transactions, such as one-time passcodes for multi-factor
authentication. Amazon SNS optimizes the message delivery to achieve
the highest reliability.
}

\code{UsageReportS3Bucket} – The name of the Amazon S3 bucket to receive
daily SMS usage reports from Amazon SNS. Each day, Amazon SNS will
deliver a usage report as a CSV file to the bucket. The report includes
the following information for each SMS message that was successfully
delivered by your account:
\itemize{
\item Time that the message was published (in UTC)
\item Message ID
\item Destination phone number
\item Message type
\item Delivery status
\item Message price (in USD)
\item Part number (a message is split into multiple parts if it is too
long for a single message)
\item Total number of parts
}

To receive the report, the bucket must have a policy that allows the
Amazon SNS service principle to perform the \code{s3:PutObject} and
\code{s3:GetBucketLocation} actions.

For an example bucket policy and usage report, see \href{https://docs.aws.amazon.com/sns/latest/dg/sms_stats.html}{Monitoring SMS Activity} in
the \emph{Amazon SNS Developer Guide}.}
}
\description{
Use this request to set the default settings for sending SMS messages
and receiving daily SMS usage reports.

You can override some of these settings for a single message when you
use the \code{Publish} action with the \code{MessageAttributes.entry.N} parameter.
For more information, see \href{https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html}{Publishing to a mobile phone}
in the \emph{Amazon SNS Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$set_sms_attributes(
  attributes = list(
    "string"
  )
)
}
}

\keyword{internal}
