% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_create_activity}
\alias{sfn_create_activity}
\title{Creates an activity}
\usage{
sfn_create_activity(name, tags)
}
\arguments{
\item{name}{[required] The name of the activity to create. This name must be unique for your
AWS account and region for 90 days. For more information, see \href{https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions}{Limits Related to State Machine Executions}
in the \emph{AWS Step Functions Developer Guide}.

A name must \emph{not} contain:
\itemize{
\item white space
\item brackets \verb{< > \{ \} [ ]}
\item wildcard characters \verb{? *}
\item special characters \verb{\\" # \% \\ ^ | ~ \\` $ & , ; : /}
\item control characters (\verb{U+0000-001F}, \verb{U+007F-009F})
}

To enable logging with CloudWatch Logs, the name should only contain
0-9, A-Z, a-z, - and _.

[ ]: R:\%20}

\item{tags}{The list of tags to add to a resource.

An array of key-value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html}{Using Cost Allocation Tags}
in the \emph{AWS Billing and Cost Management User Guide}, and \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html}{Controlling Access Using IAM Tags}.

Tags may only contain Unicode letters, digits, white space, or these
symbols: \verb{_ . : / = + - @}.}
}
\value{
A list with the following syntax:\preformatted{list(
  activityArn = "string",
  creationDate = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Creates an activity. An activity is a task that you write in any
programming language and host on any machine that has access to AWS Step
Functions. Activities must poll Step Functions using the
\code{\link[=sfn_get_activity_task]{get_activity_task}} API action and respond
using \verb{SendTask*} API actions. This function lets Step Functions know
the existence of your activity and returns an identifier for use in a
state machine and when polling from the activity.

This operation is eventually consistent. The results are best effort and
may not reflect very recent updates and changes.

\code{\link[=sfn_create_activity]{create_activity}} is an idempotent API.
Subsequent requests won’t create a duplicate resource if it was already
created. \code{\link[=sfn_create_activity]{create_activity}}'s idempotency check is
based on the activity \code{name}. If a following request has different
\code{tags} values, Step Functions will ignore these differences and treat it
as an idempotent request of the previous. In this case, \code{tags} will not
be updated, even if they are different.
}
\section{Request syntax}{
\preformatted{svc$create_activity(
  name = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
