% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mq_operations.R
\name{mq_describe_broker}
\alias{mq_describe_broker}
\title{Returns information about the specified broker}
\usage{
mq_describe_broker(BrokerId)
}
\arguments{
\item{BrokerId}{[required] The name of the broker. This value must be unique in your AWS account,
1-50 characters long, must contain only letters, numbers, dashes, and
underscores, and must not contain whitespaces, brackets, wildcard
characters, or special characters.}
}
\value{
A list with the following syntax:\preformatted{list(
  AuthenticationStrategy = "SIMPLE"|"LDAP",
  AutoMinorVersionUpgrade = TRUE|FALSE,
  BrokerArn = "string",
  BrokerId = "string",
  BrokerInstances = list(
    list(
      ConsoleURL = "string",
      Endpoints = list(
        "string"
      ),
      IpAddress = "string"
    )
  ),
  BrokerName = "string",
  BrokerState = "CREATION_IN_PROGRESS"|"CREATION_FAILED"|"DELETION_IN_PROGRESS"|"RUNNING"|"REBOOT_IN_PROGRESS",
  Configurations = list(
    Current = list(
      Id = "string",
      Revision = 123
    ),
    History = list(
      list(
        Id = "string",
        Revision = 123
      )
    ),
    Pending = list(
      Id = "string",
      Revision = 123
    )
  ),
  Created = as.POSIXct(
    "2015-01-01"
  ),
  DeploymentMode = "SINGLE_INSTANCE"|"ACTIVE_STANDBY_MULTI_AZ"|"CLUSTER_MULTI_AZ",
  EncryptionOptions = list(
    KmsKeyId = "string",
    UseAwsOwnedKey = TRUE|FALSE
  ),
  EngineType = "ACTIVEMQ"|"RABBITMQ",
  EngineVersion = "string",
  HostInstanceType = "string",
  LdapServerMetadata = list(
    Hosts = list(
      "string"
    ),
    RoleBase = "string",
    RoleName = "string",
    RoleSearchMatching = "string",
    RoleSearchSubtree = TRUE|FALSE,
    ServiceAccountUsername = "string",
    UserBase = "string",
    UserRoleName = "string",
    UserSearchMatching = "string",
    UserSearchSubtree = TRUE|FALSE
  ),
  Logs = list(
    Audit = TRUE|FALSE,
    AuditLogGroup = "string",
    General = TRUE|FALSE,
    GeneralLogGroup = "string",
    Pending = list(
      Audit = TRUE|FALSE,
      General = TRUE|FALSE
    )
  ),
  MaintenanceWindowStartTime = list(
    DayOfWeek = "MONDAY"|"TUESDAY"|"WEDNESDAY"|"THURSDAY"|"FRIDAY"|"SATURDAY"|"SUNDAY",
    TimeOfDay = "string",
    TimeZone = "string"
  ),
  PendingAuthenticationStrategy = "SIMPLE"|"LDAP",
  PendingEngineVersion = "string",
  PendingHostInstanceType = "string",
  PendingLdapServerMetadata = list(
    Hosts = list(
      "string"
    ),
    RoleBase = "string",
    RoleName = "string",
    RoleSearchMatching = "string",
    RoleSearchSubtree = TRUE|FALSE,
    ServiceAccountUsername = "string",
    UserBase = "string",
    UserRoleName = "string",
    UserSearchMatching = "string",
    UserSearchSubtree = TRUE|FALSE
  ),
  PendingSecurityGroups = list(
    "string"
  ),
  PubliclyAccessible = TRUE|FALSE,
  SecurityGroups = list(
    "string"
  ),
  StorageType = "EBS"|"EFS",
  SubnetIds = list(
    "string"
  ),
  Tags = list(
    "string"
  ),
  Users = list(
    list(
      PendingChange = "CREATE"|"UPDATE"|"DELETE",
      Username = "string"
    )
  )
)
}
}
\description{
Returns information about the specified broker.
}
\section{Request syntax}{
\preformatted{svc$describe_broker(
  BrokerId = "string"
)
}
}

\keyword{internal}
