% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_update_state_machine}
\alias{sfn_update_state_machine}
\title{Updates an existing state machine by modifying its definition and/or
roleArn}
\usage{
sfn_update_state_machine(stateMachineArn, definition, roleArn)
}
\arguments{
\item{stateMachineArn}{[required] The Amazon Resource Name (ARN) of the state machine.}

\item{definition}{The Amazon States Language definition of the state machine. See \href{https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html}{Amazon States Language}.}

\item{roleArn}{The Amazon Resource Name (ARN) of the IAM role of the state machine.}
}
\description{
Updates an existing state machine by modifying its \code{definition} and/or
\code{roleArn}. Running executions will continue to use the previous
\code{definition} and \code{roleArn}. You must include at least one of
\code{definition} or \code{roleArn} or you will receive a
\code{MissingRequiredParameter} error.
}
\details{
All \code{StartExecution} calls within a few seconds will use the updated
\code{definition} and \code{roleArn}. Executions started immediately after calling
\code{UpdateStateMachine} may use the previous state machine \code{definition} and
\code{roleArn}.
}
\section{Request syntax}{
\preformatted{svc$update_state_machine(
  stateMachineArn = "string",
  definition = "string",
  roleArn = "string"
)
}
}

\keyword{internal}
