# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Simple Queue Service
#'
#' @description
#' Welcome to the *Amazon Simple Queue Service API Reference*.
#' 
#' Amazon Simple Queue Service (Amazon SQS) is a reliable, highly-scalable
#' hosted queue for storing messages as they travel between applications or
#' microservices. Amazon SQS moves data between distributed application
#' components and helps you decouple these components.
#' 
#' You can use [AWS SDKs](http://aws.amazon.com/tools/#sdk) to access
#' Amazon SQS using your favorite programming language. The SDKs perform
#' tasks such as the following automatically:
#' 
#' -   Cryptographically sign your service requests
#' 
#' -   Retry requests
#' 
#' -   Handle error responses
#' 
#' **Additional Information**
#' 
#' -   [Amazon SQS Product Page](http://aws.amazon.com/sqs/)
#' 
#' -   *Amazon Simple Queue Service Developer Guide*
#' 
#'     -   [Making API
#'         Requests](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html)
#' 
#'     -   [Amazon SQS Message
#'         Attributes](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-attributes.html)
#' 
#'     -   [Amazon SQS Dead-Letter
#'         Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html)
#' 
#' -   [Amazon SQS in the *AWS CLI Command
#'     Reference*](http://docs.aws.amazon.com/cli/latest/reference/sqs/index.html)
#' 
#' -   *Amazon Web Services General Reference*
#' 
#'     -   [Regions and
#'         Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#sqs_region)
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- sqs(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- sqs()
#' svc$add_permission(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=sqs_add_permission]{add_permission} \tab Adds a permission to a queue for a specific principal \cr
#'  \link[=sqs_change_message_visibility]{change_message_visibility} \tab Changes the visibility timeout of a specified message in a queue to a new value \cr
#'  \link[=sqs_change_message_visibility_batch]{change_message_visibility_batch} \tab Changes the visibility timeout of multiple messages \cr
#'  \link[=sqs_create_queue]{create_queue} \tab Creates a new standard or FIFO queue \cr
#'  \link[=sqs_delete_message]{delete_message} \tab Deletes the specified message from the specified queue \cr
#'  \link[=sqs_delete_message_batch]{delete_message_batch} \tab Deletes up to ten messages from the specified queue \cr
#'  \link[=sqs_delete_queue]{delete_queue} \tab Deletes the queue specified by the QueueUrl, regardless of the queue's contents \cr
#'  \link[=sqs_get_queue_attributes]{get_queue_attributes} \tab Gets attributes for the specified queue \cr
#'  \link[=sqs_get_queue_url]{get_queue_url} \tab Returns the URL of an existing Amazon SQS queue \cr
#'  \link[=sqs_list_dead_letter_source_queues]{list_dead_letter_source_queues} \tab Returns a list of your queues that have the RedrivePolicy queue attribute configured with a dead-letter queue\cr
#'  \link[=sqs_list_queues]{list_queues} \tab Returns a list of your queues \cr
#'  \link[=sqs_list_queue_tags]{list_queue_tags} \tab List all cost allocation tags added to the specified Amazon SQS queue \cr
#'  \link[=sqs_purge_queue]{purge_queue} \tab Deletes the messages in a queue specified by the QueueURL parameter \cr
#'  \link[=sqs_receive_message]{receive_message} \tab Retrieves one or more messages (up to 10), from the specified queue \cr
#'  \link[=sqs_remove_permission]{remove_permission} \tab Revokes any permissions in the queue policy that matches the specified Label parameter \cr
#'  \link[=sqs_send_message]{send_message} \tab Delivers a message to the specified queue \cr
#'  \link[=sqs_send_message_batch]{send_message_batch} \tab Delivers up to ten messages to the specified queue \cr
#'  \link[=sqs_set_queue_attributes]{set_queue_attributes} \tab Sets the value of one or more queue attributes \cr
#'  \link[=sqs_tag_queue]{tag_queue} \tab Add cost allocation tags to the specified Amazon SQS queue \cr
#'  \link[=sqs_untag_queue]{untag_queue} \tab Remove cost allocation tags from the specified Amazon SQS queue 
#' }
#'
#' @rdname sqs
#' @export
sqs <- function(config = list()) {
  svc <- .sqs$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.sqs <- list()

.sqs$operations <- list()

.sqs$metadata <- list(
  service_name = "sqs",
  endpoints = list("*" = list(endpoint = "sqs.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "sqs.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "SQS",
  api_version = "2012-11-05",
  signing_name = NULL,
  json_version = "",
  target_prefix = ""
)

.sqs$handlers <- new_handlers("query", "v4")

.sqs$service <- function(config = list()) {
  new_service(.sqs$metadata, .sqs$handlers, config)
}
