% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_set_subscription_attributes}
\alias{sns_set_subscription_attributes}
\title{Allows a subscription owner to set an attribute of the subscription to a
new value}
\usage{
sns_set_subscription_attributes(SubscriptionArn, AttributeName,
  AttributeValue)
}
\arguments{
\item{SubscriptionArn}{[required] The ARN of the subscription to modify.}

\item{AttributeName}{[required] A map of attributes with their corresponding values.

The following lists the names, descriptions, and values of the special
request parameters that the \code{SetTopicAttributes} action uses:
\itemize{
\item \code{DeliveryPolicy} -- The policy that defines how Amazon SNS retries
failed deliveries to HTTP/S endpoints.
\item \code{FilterPolicy} -- The simple JSON object that lets your subscriber
receive only a subset of messages, rather than receiving every
message published to the topic.
\item \code{RawMessageDelivery} -- When set to \code{true}, enables raw message
delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need
for the endpoints to process JSON formatting, which is otherwise
created for Amazon SNS metadata.
\item \code{RedrivePolicy} -- When specified, sends undeliverable messages to
the specified Amazon SQS dead-letter queue. Messages that can\'t be
delivered due to client errors (for example, when the subscribed
endpoint is unreachable) or server errors (for example, when the
service that powers the subscribed endpoint becomes unavailable) are
held in the dead-letter queue for further analysis or reprocessing.
}}

\item{AttributeValue}{The new value for the attribute in JSON format.}
}
\description{
Allows a subscription owner to set an attribute of the subscription to a
new value.
}
\section{Request syntax}{
\preformatted{svc$set_subscription_attributes(
  SubscriptionArn = "string",
  AttributeName = "string",
  AttributeValue = "string"
)
}
}

\keyword{internal}
