% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_create_topic}
\alias{sns_create_topic}
\title{Creates a topic to which notifications can be published}
\usage{
sns_create_topic(Name, Attributes, Tags)
}
\arguments{
\item{Name}{[required] The name of the topic you want to create.

Constraints: Topic names must be made up of only uppercase and lowercase
ASCII letters, numbers, underscores, and hyphens, and must be between 1
and 256 characters long.

For a FIFO (first-in-first-out) topic, the name must end with the
\code{.fifo} suffix.}

\item{Attributes}{A map of attributes with their corresponding values.

The following lists the names, descriptions, and values of the special
request parameters that the \code{CreateTopic} action uses:
\itemize{
\item \code{DeliveryPolicy} -- The policy that defines how Amazon SNS retries
failed deliveries to HTTP/S endpoints.
\item \code{DisplayName} -- The display name to use for a topic with SMS
subscriptions.
\item \code{FifoTopic} -- Set to true to create a FIFO topic.
\item \code{Policy} -- The policy that defines who can access your topic. By
default, only the topic owner can publish or subscribe to the topic.
}

The following attribute applies only to
\href{https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html}{server-side-encryption}:
\itemize{
\item \code{KmsMasterKeyId} -- The ID of an AWS-managed customer master key
(CMK) for Amazon SNS or a custom CMK. For more information, see \href{https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms}{Key Terms}.
For more examples, see
\href{https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters}{KeyId}
in the \emph{AWS Key Management Service API Reference}.
}

The following attribute applies only to FIFO topics:
\itemize{
\item \code{ContentBasedDeduplication} -- Enables content-based deduplication.
Amazon SNS uses a SHA-256 hash to generate the
\code{MessageDeduplicationId} using the body of the message (but not the
attributes of the message).
\item When \code{ContentBasedDeduplication} is in effect, messages with
identical content sent within the deduplication interval are treated
as duplicates and only one copy of the message is delivered.
\item If the queue has \code{ContentBasedDeduplication} set, your
\code{MessageDeduplicationId} overrides the generated one.
}}

\item{Tags}{The list of tags to add to a new topic.

To be able to tag a topic on creation, you must have the
\code{sns:CreateTopic} and \code{sns:TagResource} permissions.}
}
\description{
Creates a topic to which notifications can be published. Users can
create at most 100,000 standard topics (at most 1,000 FIFO topics). For
more information, see
\href{http://aws.amazon.com/sns/}{https://aws.amazon.com/sns}. This action is
idempotent, so if the requester already owns a topic with the specified
name, that topic\'s ARN is returned without creating a new topic.
}
\section{Request syntax}{
\preformatted{svc$create_topic(
  Name = "string",
  Attributes = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
