% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_set_topic_attributes}
\alias{sns_set_topic_attributes}
\title{Allows a topic owner to set an attribute of the topic to a new value}
\usage{
sns_set_topic_attributes(TopicArn, AttributeName, AttributeValue)
}
\arguments{
\item{TopicArn}{[required] The ARN of the topic to modify.}

\item{AttributeName}{[required] A map of attributes with their corresponding values.

The following lists the names, descriptions, and values of the special
request parameters that the \code{SetTopicAttributes} action uses:
\itemize{
\item \code{DeliveryPolicy} -- The policy that defines how Amazon SNS retries
failed deliveries to HTTP/S endpoints.
\item \code{DisplayName} -- The display name to use for a topic with SMS
subscriptions.
\item \code{Policy} -- The policy that defines who can access your topic. By
default, only the topic owner can publish or subscribe to the topic.
}

The following attribute applies only to
\href{https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html}{server-side-encryption}:
\itemize{
\item \code{KmsMasterKeyId} -- The ID of an AWS-managed customer master key
(CMK) for Amazon SNS or a custom CMK. For more information, see \href{https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms}{Key Terms}.
For more examples, see
\href{https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters}{KeyId}
in the \emph{AWS Key Management Service API Reference}.
}

The following attribute applies only to FIFO topics:
\itemize{
\item \code{ContentBasedDeduplication} -- Enables content-based deduplication.
Amazon SNS uses a SHA-256 hash to generate the
\code{MessageDeduplicationId} using the body of the message (but not the
attributes of the message).
\item When \code{ContentBasedDeduplication} is in effect, messages with
identical content sent within the deduplication interval are treated
as duplicates and only one copy of the message is delivered.
\item If the queue has \code{ContentBasedDeduplication} set, your
\code{MessageDeduplicationId} overrides the generated one.
}}

\item{AttributeValue}{The new value for the attribute.}
}
\description{
Allows a topic owner to set an attribute of the topic to a new value.
}
\section{Request syntax}{
\preformatted{svc$set_topic_attributes(
  TopicArn = "string",
  AttributeName = "string",
  AttributeValue = "string"
)
}
}

\keyword{internal}
