% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_list_executions}
\alias{sfn_list_executions}
\title{Lists all executions of a state machine or a Map Run}
\usage{
sfn_list_executions(
  stateMachineArn = NULL,
  statusFilter = NULL,
  maxResults = NULL,
  nextToken = NULL,
  mapRunArn = NULL
)
}
\arguments{
\item{stateMachineArn}{The Amazon Resource Name (ARN) of the state machine whose executions is
listed.

You can specify either a \code{mapRunArn} or a \code{stateMachineArn}, but not
both.}

\item{statusFilter}{If specified, only list the executions whose current execution status
matches the given filter.}

\item{maxResults}{The maximum number of results that are returned per call. You can use
\code{nextToken} to obtain further pages of results. The default is 100 and
the maximum allowed page size is 1000. A value of 0 uses the default.

This is only an upper limit. The actual number of results returned per
call might be fewer than the specified maximum.}

\item{nextToken}{If \code{nextToken} is returned, there are more results available. The value
of \code{nextToken} is a unique pagination token for each page. Make the call
again using the returned token to retrieve the next page. Keep all other
arguments unchanged. Each pagination token expires after 24 hours. Using
an expired pagination token will return an \emph{HTTP 400 InvalidToken}
error.}

\item{mapRunArn}{The Amazon Resource Name (ARN) of the Map Run that started the child
workflow executions. If the \code{mapRunArn} field is specified, a list of
all of the child workflow executions started by a Map Run is returned.
For more information, see \href{https://docs.aws.amazon.com/step-functions/latest/dg/concepts-examine-map-run.html}{Examining Map Run}
in the \emph{Step Functions Developer Guide}.

You can specify either a \code{mapRunArn} or a \code{stateMachineArn}, but not
both.}
}
\description{
Lists all executions of a state machine or a Map Run. You can list all executions related to a state machine by specifying a state machine Amazon Resource Name (ARN), or those related to a Map Run by specifying a Map Run ARN.

See \url{https://www.paws-r-sdk.com/docs/sfn_list_executions/} for full documentation.
}
\keyword{internal}
