% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_list_endpoints_by_platform_application}
\alias{sns_list_endpoints_by_platform_application}
\title{Lists the endpoints and endpoint attributes for devices in a supported
push notification service, such as GCM (Firebase Cloud Messaging) and
APNS}
\usage{
sns_list_endpoints_by_platform_application(
  PlatformApplicationArn,
  NextToken = NULL
)
}
\arguments{
\item{PlatformApplicationArn}{[required] PlatformApplicationArn for ListEndpointsByPlatformApplicationInput
action.}

\item{NextToken}{NextToken string is used when calling ListEndpointsByPlatformApplication
action to retrieve additional records that are available after the first
page results.}
}
\description{
Lists the endpoints and endpoint attributes for devices in a supported push notification service, such as GCM (Firebase Cloud Messaging) and APNS. The results for \code{\link[=sns_list_endpoints_by_platform_application]{list_endpoints_by_platform_application}} are paginated and return a limited list of endpoints, up to 100. If additional records are available after the first page results, then a NextToken string will be returned. To receive the next page, you call \code{\link[=sns_list_endpoints_by_platform_application]{list_endpoints_by_platform_application}} again using the NextToken string received from the previous call. When there are no more records to return, NextToken will be null. For more information, see \href{https://docs.aws.amazon.com/sns/latest/dg/sns-mobile-application-as-subscriber.html}{Using Amazon SNS Mobile Push Notifications}.

See \url{https://www.paws-r-sdk.com/docs/sns_list_endpoints_by_platform_application/} for full documentation.
}
\keyword{internal}
