% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_start_message_move_task}
\alias{sqs_start_message_move_task}
\title{Starts an asynchronous task to move messages from a specified source
queue to a specified destination queue}
\usage{
sqs_start_message_move_task(
  SourceArn,
  DestinationArn = NULL,
  MaxNumberOfMessagesPerSecond = NULL
)
}
\arguments{
\item{SourceArn}{[required] The ARN of the queue that contains the messages to be moved to another
queue. Currently, only dead-letter queue (DLQ) ARNs are accepted.}

\item{DestinationArn}{The ARN of the queue that receives the moved messages. You can use this
field to specify the destination queue where you would like to redrive
messages. If this field is left blank, the messages will be redriven
back to their respective original source queues.}

\item{MaxNumberOfMessagesPerSecond}{The number of messages to be moved per second (the message movement
rate). You can use this field to define a fixed message movement rate.
The maximum value for messages per second is 500. If this field is left
blank, the system will optimize the rate based on the queue message
backlog size, which may vary throughout the duration of the message
movement task.}
}
\description{
Starts an asynchronous task to move messages from a specified source queue to a specified destination queue.

See \url{https://www.paws-r-sdk.com/docs/sqs_start_message_move_task/} for full documentation.
}
\keyword{internal}
