# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sqs_service.R
NULL

#' Adds a permission to a queue for a specific principal
#'
#' @description
#' Adds a permission to a queue for a specific [principal](https://docs.aws.amazon.com/glossary/latest/reference/glos-chap.html#P). This allows sharing access to the queue.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_add_permission/](https://www.paws-r-sdk.com/docs/sqs_add_permission/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue to which permissions are added.
#' 
#' Queue URLs and names are case-sensitive.
#' @param Label &#91;required&#93; The unique identification of the permission you're setting (for example,
#' `AliceSendMessage`). Maximum 80 characters. Allowed characters include
#' alphanumeric characters, hyphens (`-`), and underscores (`_`).
#' @param AWSAccountIds &#91;required&#93; The Amazon Web Services account numbers of the
#' [principals](https://docs.aws.amazon.com/glossary/latest/reference/glos-chap.html#P)
#' who are to receive permission. For information about locating the Amazon
#' Web Services account identification, see [Your Amazon Web Services
#' Identifiers](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests-xml.html#sqs-api-request-authentication)
#' in the *Amazon SQS Developer Guide*.
#' @param Actions &#91;required&#93; The action the client wants to allow for the specified principal. Valid
#' values: the name of any action or `*`.
#' 
#' For more information about these actions, see [Overview of Managing
#' Access Permissions to Your Amazon Simple Queue Service
#' Resource](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html)
#' in the *Amazon SQS Developer Guide*.
#' 
#' Specifying [`send_message`][sqs_send_message],
#' [`delete_message`][sqs_delete_message], or
#' [`change_message_visibility`][sqs_change_message_visibility] for
#' `ActionName.n` also grants permissions for the corresponding batch
#' versions of those actions:
#' [`send_message_batch`][sqs_send_message_batch],
#' [`delete_message_batch`][sqs_delete_message_batch], and
#' [`change_message_visibility_batch`][sqs_change_message_visibility_batch].
#'
#' @keywords internal
#'
#' @rdname sqs_add_permission
sqs_add_permission <- function(QueueUrl, Label, AWSAccountIds, Actions) {
  op <- new_operation(
    name = "AddPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$add_permission_input(QueueUrl = QueueUrl, Label = Label, AWSAccountIds = AWSAccountIds, Actions = Actions)
  output <- .sqs$add_permission_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$add_permission <- sqs_add_permission

#' Cancels a specified message movement task
#'
#' @description
#' Cancels a specified message movement task. A message movement can only be cancelled when the current status is RUNNING. Cancelling a message movement task does not revert the messages that have already been moved. It can only stop the messages that have not been moved yet.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_cancel_message_move_task/](https://www.paws-r-sdk.com/docs/sqs_cancel_message_move_task/) for full documentation.
#'
#' @param TaskHandle &#91;required&#93; An identifier associated with a message movement task.
#'
#' @keywords internal
#'
#' @rdname sqs_cancel_message_move_task
sqs_cancel_message_move_task <- function(TaskHandle) {
  op <- new_operation(
    name = "CancelMessageMoveTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$cancel_message_move_task_input(TaskHandle = TaskHandle)
  output <- .sqs$cancel_message_move_task_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$cancel_message_move_task <- sqs_cancel_message_move_task

#' Changes the visibility timeout of a specified message in a queue to a
#' new value
#'
#' @description
#' Changes the visibility timeout of a specified message in a queue to a new value. The default visibility timeout for a message is 30 seconds. The minimum is 0 seconds. The maximum is 12 hours. For more information, see [Visibility Timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html) in the *Amazon SQS Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_change_message_visibility/](https://www.paws-r-sdk.com/docs/sqs_change_message_visibility/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue whose message's visibility is changed.
#' 
#' Queue URLs and names are case-sensitive.
#' @param ReceiptHandle &#91;required&#93; The receipt handle associated with the message, whose visibility timeout
#' is changed. This parameter is returned by the
#' [`receive_message`][sqs_receive_message] action.
#' @param VisibilityTimeout &#91;required&#93; The new value for the message's visibility timeout (in seconds). Values
#' range: `0` to `43200`. Maximum: 12 hours.
#'
#' @keywords internal
#'
#' @rdname sqs_change_message_visibility
sqs_change_message_visibility <- function(QueueUrl, ReceiptHandle, VisibilityTimeout) {
  op <- new_operation(
    name = "ChangeMessageVisibility",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$change_message_visibility_input(QueueUrl = QueueUrl, ReceiptHandle = ReceiptHandle, VisibilityTimeout = VisibilityTimeout)
  output <- .sqs$change_message_visibility_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$change_message_visibility <- sqs_change_message_visibility

#' Changes the visibility timeout of multiple messages
#'
#' @description
#' Changes the visibility timeout of multiple messages. This is a batch version of ` ChangeMessageVisibility.` The result of the action on each message is reported individually in the response. You can send up to 10 [`change_message_visibility`][sqs_change_message_visibility] requests with each [`change_message_visibility_batch`][sqs_change_message_visibility_batch] action.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_change_message_visibility_batch/](https://www.paws-r-sdk.com/docs/sqs_change_message_visibility_batch/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue whose messages' visibility is changed.
#' 
#' Queue URLs and names are case-sensitive.
#' @param Entries &#91;required&#93; Lists the receipt handles of the messages for which the visibility
#' timeout must be changed.
#'
#' @keywords internal
#'
#' @rdname sqs_change_message_visibility_batch
sqs_change_message_visibility_batch <- function(QueueUrl, Entries) {
  op <- new_operation(
    name = "ChangeMessageVisibilityBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$change_message_visibility_batch_input(QueueUrl = QueueUrl, Entries = Entries)
  output <- .sqs$change_message_visibility_batch_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$change_message_visibility_batch <- sqs_change_message_visibility_batch

#' Creates a new standard or FIFO queue
#'
#' @description
#' Creates a new standard or FIFO queue. You can pass one or more attributes in the request. Keep the following in mind:
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_create_queue/](https://www.paws-r-sdk.com/docs/sqs_create_queue/) for full documentation.
#'
#' @param QueueName &#91;required&#93; The name of the new queue. The following limits apply to this name:
#' 
#' -   A queue name can have up to 80 characters.
#' 
#' -   Valid values: alphanumeric characters, hyphens (`-`), and
#'     underscores (`_`).
#' 
#' -   A FIFO queue name must end with the `.fifo` suffix.
#' 
#' Queue URLs and names are case-sensitive.
#' @param Attributes A map of attributes with their corresponding values.
#' 
#' The following lists the names, descriptions, and values of the special
#' request parameters that the [`create_queue`][sqs_create_queue] action
#' uses:
#' 
#' -   `DelaySeconds` – The length of time, in seconds, for which the
#'     delivery of all messages in the queue is delayed. Valid values: An
#'     integer from 0 to 900 seconds (15 minutes). Default: 0.
#' 
#' -   `MaximumMessageSize` – The limit of how many bytes a message can
#'     contain before Amazon SQS rejects it. Valid values: An integer from
#'     1,024 bytes (1 KiB) to 262,144 bytes (256 KiB). Default: 262,144
#'     (256 KiB).
#' 
#' -   `MessageRetentionPeriod` – The length of time, in seconds, for which
#'     Amazon SQS retains a message. Valid values: An integer from 60
#'     seconds (1 minute) to 1,209,600 seconds (14 days). Default: 345,600
#'     (4 days). When you change a queue's attributes, the change can take
#'     up to 60 seconds for most of the attributes to propagate throughout
#'     the Amazon SQS system. Changes made to the `MessageRetentionPeriod`
#'     attribute can take up to 15 minutes and will impact existing
#'     messages in the queue potentially causing them to be expired and
#'     deleted if the `MessageRetentionPeriod` is reduced below the age of
#'     existing messages.
#' 
#' -   `Policy` – The queue's policy. A valid Amazon Web Services policy.
#'     For more information about policy structure, see [Overview of Amazon
#'     Web Services IAM
#'     Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html)
#'     in the *IAM User Guide*.
#' 
#' -   `ReceiveMessageWaitTimeSeconds` – The length of time, in seconds,
#'     for which a [`receive_message`][sqs_receive_message] action waits
#'     for a message to arrive. Valid values: An integer from 0 to 20
#'     (seconds). Default: 0.
#' 
#' -   `VisibilityTimeout` – The visibility timeout for the queue, in
#'     seconds. Valid values: An integer from 0 to 43,200 (12 hours).
#'     Default: 30. For more information about the visibility timeout, see
#'     [Visibility
#'     Timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html)
#'     in the *Amazon SQS Developer Guide*.
#' 
#' The following attributes apply only to [dead-letter
#' queues:](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html)
#' 
#' -   `RedrivePolicy` – The string that includes the parameters for the
#'     dead-letter queue functionality of the source queue as a JSON
#'     object. The parameters are as follows:
#' 
#'     -   `deadLetterTargetArn` – The Amazon Resource Name (ARN) of the
#'         dead-letter queue to which Amazon SQS moves messages after the
#'         value of `maxReceiveCount` is exceeded.
#' 
#'     -   `maxReceiveCount` – The number of times a message is delivered
#'         to the source queue before being moved to the dead-letter queue.
#'         Default: 10. When the `ReceiveCount` for a message exceeds the
#'         `maxReceiveCount` for a queue, Amazon SQS moves the message to
#'         the dead-letter-queue.
#' 
#' -   `RedriveAllowPolicy` – The string that includes the parameters for
#'     the permissions for the dead-letter queue redrive permission and
#'     which source queues can specify dead-letter queues as a JSON object.
#'     The parameters are as follows:
#' 
#'     -   `redrivePermission` – The permission type that defines which
#'         source queues can specify the current queue as the dead-letter
#'         queue. Valid values are:
#' 
#'         -   `allowAll` – (Default) Any source queues in this Amazon Web
#'             Services account in the same Region can specify this queue
#'             as the dead-letter queue.
#' 
#'         -   `denyAll` – No source queues can specify this queue as the
#'             dead-letter queue.
#' 
#'         -   `byQueue` – Only queues specified by the `sourceQueueArns`
#'             parameter can specify this queue as the dead-letter queue.
#' 
#'     -   `sourceQueueArns` – The Amazon Resource Names (ARN)s of the
#'         source queues that can specify this queue as the dead-letter
#'         queue and redrive messages. You can specify this parameter only
#'         when the `redrivePermission` parameter is set to `byQueue`. You
#'         can specify up to 10 source queue ARNs. To allow more than 10
#'         source queues to specify dead-letter queues, set the
#'         `redrivePermission` parameter to `allowAll`.
#' 
#' The dead-letter queue of a FIFO queue must also be a FIFO queue.
#' Similarly, the dead-letter queue of a standard queue must also be a
#' standard queue.
#' 
#' The following attributes apply only to
#' [server-side-encryption](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html):
#' 
#' -   `KmsMasterKeyId` – The ID of an Amazon Web Services managed customer
#'     master key (CMK) for Amazon SQS or a custom CMK. For more
#'     information, see [Key
#'     Terms](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms).
#'     While the alias of the Amazon Web Services managed CMK for Amazon
#'     SQS is always `alias/aws/sqs`, the alias of a custom CMK can, for
#'     example, be `alias/MyAlias `. For more examples, see
#'     [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters)
#'     in the *Key Management Service API Reference*.
#' 
#' -   `KmsDataKeyReusePeriodSeconds` – The length of time, in seconds, for
#'     which Amazon SQS can reuse a [data
#'     key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-keys)
#'     to encrypt or decrypt messages before calling KMS again. An integer
#'     representing seconds, between 60 seconds (1 minute) and 86,400
#'     seconds (24 hours). Default: 300 (5 minutes). A shorter time period
#'     provides better security but results in more calls to KMS which
#'     might incur charges after Free Tier. For more information, see [How
#'     Does the Data Key Reuse Period
#'     Work?](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work)
#' 
#' -   `SqsManagedSseEnabled` – Enables server-side queue encryption using
#'     SQS owned encryption keys. Only one server-side encryption option is
#'     supported per queue (for example,
#'     [SSE-KMS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html)
#'     or
#'     [SSE-SQS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html)).
#' 
#' The following attributes apply only to [FIFO (first-in-first-out)
#' queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/):
#' 
#' -   `FifoQueue` – Designates a queue as FIFO. Valid values are `true`
#'     and `false`. If you don't specify the `FifoQueue` attribute, Amazon
#'     SQS creates a standard queue. You can provide this attribute only
#'     during queue creation. You can't change it for an existing queue.
#'     When you set this attribute, you must also provide the
#'     `MessageGroupId` for your messages explicitly.
#' 
#'     For more information, see [FIFO queue
#'     logic](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html)
#'     in the *Amazon SQS Developer Guide*.
#' 
#' -   `ContentBasedDeduplication` – Enables content-based deduplication.
#'     Valid values are `true` and `false`. For more information, see
#'     [Exactly-once
#'     processing](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html)
#'     in the *Amazon SQS Developer Guide*. Note the following:
#' 
#'     -   Every message must have a unique `MessageDeduplicationId`.
#' 
#'         -   You may provide a `MessageDeduplicationId` explicitly.
#' 
#'         -   If you aren't able to provide a `MessageDeduplicationId` and
#'             you enable `ContentBasedDeduplication` for your queue,
#'             Amazon SQS uses a SHA-256 hash to generate the
#'             `MessageDeduplicationId` using the body of the message (but
#'             not the attributes of the message).
#' 
#'         -   If you don't provide a `MessageDeduplicationId` and the
#'             queue doesn't have `ContentBasedDeduplication` set, the
#'             action fails with an error.
#' 
#'         -   If the queue has `ContentBasedDeduplication` set, your
#'             `MessageDeduplicationId` overrides the generated one.
#' 
#'     -   When `ContentBasedDeduplication` is in effect, messages with
#'         identical content sent within the deduplication interval are
#'         treated as duplicates and only one copy of the message is
#'         delivered.
#' 
#'     -   If you send one message with `ContentBasedDeduplication` enabled
#'         and then another message with a `MessageDeduplicationId` that is
#'         the same as the one generated for the first
#'         `MessageDeduplicationId`, the two messages are treated as
#'         duplicates and only one copy of the message is delivered.
#' 
#' The following attributes apply only to [high throughput for FIFO
#' queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html):
#' 
#' -   `DeduplicationScope` – Specifies whether message deduplication
#'     occurs at the message group or queue level. Valid values are
#'     `messageGroup` and `queue`.
#' 
#' -   `FifoThroughputLimit` – Specifies whether the FIFO queue throughput
#'     quota applies to the entire queue or per message group. Valid values
#'     are `perQueue` and `perMessageGroupId`. The `perMessageGroupId`
#'     value is allowed only when the value for `DeduplicationScope` is
#'     `messageGroup`.
#' 
#' To enable high throughput for FIFO queues, do the following:
#' 
#' -   Set `DeduplicationScope` to `messageGroup`.
#' 
#' -   Set `FifoThroughputLimit` to `perMessageGroupId`.
#' 
#' If you set these attributes to anything other than the values shown for
#' enabling high throughput, normal throughput is in effect and
#' deduplication occurs as specified.
#' 
#' For information on throughput quotas, see [Quotas related to
#' messages](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html)
#' in the *Amazon SQS Developer Guide*.
#' @param tags Add cost allocation tags to the specified Amazon SQS queue. For an
#' overview, see [Tagging Your Amazon SQS
#' Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html)
#' in the *Amazon SQS Developer Guide*.
#' 
#' When you use queue tags, keep the following guidelines in mind:
#' 
#' -   Adding more than 50 tags to a queue isn't recommended.
#' 
#' -   Tags don't have any semantic meaning. Amazon SQS interprets tags as
#'     character strings.
#' 
#' -   Tags are case-sensitive.
#' 
#' -   A new tag with a key identical to that of an existing tag overwrites
#'     the existing tag.
#' 
#' For a full list of tag restrictions, see [Quotas related to
#' queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-quotas.html#limits-queues)
#' in the *Amazon SQS Developer Guide*.
#' 
#' To be able to tag a queue on creation, you must have the
#' `sqs:CreateQueue` and `sqs:TagQueue` permissions.
#' 
#' Cross-account permissions don't apply to this action. For more
#' information, see [Grant cross-account permissions to a role and a
#' username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-basic-examples-of-sqs-policies.html#grant-cross-account-permissions-to-role-and-user-name)
#' in the *Amazon SQS Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname sqs_create_queue
sqs_create_queue <- function(QueueName, Attributes = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateQueue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$create_queue_input(QueueName = QueueName, Attributes = Attributes, tags = tags)
  output <- .sqs$create_queue_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$create_queue <- sqs_create_queue

#' Deletes the specified message from the specified queue
#'
#' @description
#' Deletes the specified message from the specified queue. To select the message to delete, use the `ReceiptHandle` of the message (*not* the `MessageId` which you receive when you send the message). Amazon SQS can delete a message from a queue even if a visibility timeout setting causes the message to be locked by another consumer. Amazon SQS automatically deletes messages left in a queue longer than the retention period configured for the queue.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_delete_message/](https://www.paws-r-sdk.com/docs/sqs_delete_message/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue from which messages are deleted.
#' 
#' Queue URLs and names are case-sensitive.
#' @param ReceiptHandle &#91;required&#93; The receipt handle associated with the message to delete.
#'
#' @keywords internal
#'
#' @rdname sqs_delete_message
sqs_delete_message <- function(QueueUrl, ReceiptHandle) {
  op <- new_operation(
    name = "DeleteMessage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$delete_message_input(QueueUrl = QueueUrl, ReceiptHandle = ReceiptHandle)
  output <- .sqs$delete_message_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$delete_message <- sqs_delete_message

#' Deletes up to ten messages from the specified queue
#'
#' @description
#' Deletes up to ten messages from the specified queue. This is a batch version of ` DeleteMessage.` The result of the action on each message is reported individually in the response.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_delete_message_batch/](https://www.paws-r-sdk.com/docs/sqs_delete_message_batch/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue from which messages are deleted.
#' 
#' Queue URLs and names are case-sensitive.
#' @param Entries &#91;required&#93; Lists the receipt handles for the messages to be deleted.
#'
#' @keywords internal
#'
#' @rdname sqs_delete_message_batch
sqs_delete_message_batch <- function(QueueUrl, Entries) {
  op <- new_operation(
    name = "DeleteMessageBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$delete_message_batch_input(QueueUrl = QueueUrl, Entries = Entries)
  output <- .sqs$delete_message_batch_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$delete_message_batch <- sqs_delete_message_batch

#' Deletes the queue specified by the QueueUrl, regardless of the queue's
#' contents
#'
#' @description
#' Deletes the queue specified by the `QueueUrl`, regardless of the queue's contents.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_delete_queue/](https://www.paws-r-sdk.com/docs/sqs_delete_queue/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue to delete.
#' 
#' Queue URLs and names are case-sensitive.
#'
#' @keywords internal
#'
#' @rdname sqs_delete_queue
sqs_delete_queue <- function(QueueUrl) {
  op <- new_operation(
    name = "DeleteQueue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$delete_queue_input(QueueUrl = QueueUrl)
  output <- .sqs$delete_queue_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$delete_queue <- sqs_delete_queue

#' Gets attributes for the specified queue
#'
#' @description
#' Gets attributes for the specified queue.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_get_queue_attributes/](https://www.paws-r-sdk.com/docs/sqs_get_queue_attributes/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue whose attribute information is
#' retrieved.
#' 
#' Queue URLs and names are case-sensitive.
#' @param AttributeNames A list of attributes for which to retrieve information.
#' 
#' The `AttributeNames` parameter is optional, but if you don't specify
#' values for this parameter, the request returns empty results.
#' 
#' In the future, new attributes might be added. If you write code that
#' calls this action, we recommend that you structure your code so that it
#' can handle new attributes gracefully.
#' 
#' The following attributes are supported:
#' 
#' The `ApproximateNumberOfMessagesDelayed`,
#' `ApproximateNumberOfMessagesNotVisible`, and
#' `ApproximateNumberOfMessages` metrics may not achieve consistency until
#' at least 1 minute after the producers stop sending messages. This period
#' is required for the queue metadata to reach eventual consistency.
#' 
#' -   `All` – Returns all values.
#' 
#' -   `ApproximateNumberOfMessages` – Returns the approximate number of
#'     messages available for retrieval from the queue.
#' 
#' -   `ApproximateNumberOfMessagesDelayed` – Returns the approximate
#'     number of messages in the queue that are delayed and not available
#'     for reading immediately. This can happen when the queue is
#'     configured as a delay queue or when a message has been sent with a
#'     delay parameter.
#' 
#' -   `ApproximateNumberOfMessagesNotVisible` – Returns the approximate
#'     number of messages that are in flight. Messages are considered to be
#'     *in flight* if they have been sent to a client but have not yet been
#'     deleted or have not yet reached the end of their visibility window.
#' 
#' -   `CreatedTimestamp` – Returns the time when the queue was created in
#'     seconds ([epoch time](https://en.wikipedia.org/wiki/Unix_time)).
#' 
#' -   `DelaySeconds` – Returns the default delay on the queue in seconds.
#' 
#' -   `LastModifiedTimestamp` – Returns the time when the queue was last
#'     changed in seconds ([epoch
#'     time](https://en.wikipedia.org/wiki/Unix_time)).
#' 
#' -   `MaximumMessageSize` – Returns the limit of how many bytes a message
#'     can contain before Amazon SQS rejects it.
#' 
#' -   `MessageRetentionPeriod` – Returns the length of time, in seconds,
#'     for which Amazon SQS retains a message. When you change a queue's
#'     attributes, the change can take up to 60 seconds for most of the
#'     attributes to propagate throughout the Amazon SQS system. Changes
#'     made to the `MessageRetentionPeriod` attribute can take up to 15
#'     minutes and will impact existing messages in the queue potentially
#'     causing them to be expired and deleted if the
#'     `MessageRetentionPeriod` is reduced below the age of existing
#'     messages.
#' 
#' -   `Policy` – Returns the policy of the queue.
#' 
#' -   `QueueArn` – Returns the Amazon resource name (ARN) of the queue.
#' 
#' -   `ReceiveMessageWaitTimeSeconds` – Returns the length of time, in
#'     seconds, for which the [`receive_message`][sqs_receive_message]
#'     action waits for a message to arrive.
#' 
#' -   `VisibilityTimeout` – Returns the visibility timeout for the queue.
#'     For more information about the visibility timeout, see [Visibility
#'     Timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html)
#'     in the *Amazon SQS Developer Guide*.
#' 
#' The following attributes apply only to [dead-letter
#' queues:](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html)
#' 
#' -   `RedrivePolicy` – The string that includes the parameters for the
#'     dead-letter queue functionality of the source queue as a JSON
#'     object. The parameters are as follows:
#' 
#'     -   `deadLetterTargetArn` – The Amazon Resource Name (ARN) of the
#'         dead-letter queue to which Amazon SQS moves messages after the
#'         value of `maxReceiveCount` is exceeded.
#' 
#'     -   `maxReceiveCount` – The number of times a message is delivered
#'         to the source queue before being moved to the dead-letter queue.
#'         Default: 10. When the `ReceiveCount` for a message exceeds the
#'         `maxReceiveCount` for a queue, Amazon SQS moves the message to
#'         the dead-letter-queue.
#' 
#' -   `RedriveAllowPolicy` – The string that includes the parameters for
#'     the permissions for the dead-letter queue redrive permission and
#'     which source queues can specify dead-letter queues as a JSON object.
#'     The parameters are as follows:
#' 
#'     -   `redrivePermission` – The permission type that defines which
#'         source queues can specify the current queue as the dead-letter
#'         queue. Valid values are:
#' 
#'         -   `allowAll` – (Default) Any source queues in this Amazon Web
#'             Services account in the same Region can specify this queue
#'             as the dead-letter queue.
#' 
#'         -   `denyAll` – No source queues can specify this queue as the
#'             dead-letter queue.
#' 
#'         -   `byQueue` – Only queues specified by the `sourceQueueArns`
#'             parameter can specify this queue as the dead-letter queue.
#' 
#'     -   `sourceQueueArns` – The Amazon Resource Names (ARN)s of the
#'         source queues that can specify this queue as the dead-letter
#'         queue and redrive messages. You can specify this parameter only
#'         when the `redrivePermission` parameter is set to `byQueue`. You
#'         can specify up to 10 source queue ARNs. To allow more than 10
#'         source queues to specify dead-letter queues, set the
#'         `redrivePermission` parameter to `allowAll`.
#' 
#' The dead-letter queue of a FIFO queue must also be a FIFO queue.
#' Similarly, the dead-letter queue of a standard queue must also be a
#' standard queue.
#' 
#' The following attributes apply only to
#' [server-side-encryption](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html):
#' 
#' -   `KmsMasterKeyId` – Returns the ID of an Amazon Web Services managed
#'     customer master key (CMK) for Amazon SQS or a custom CMK. For more
#'     information, see [Key
#'     Terms](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms).
#' 
#' -   `KmsDataKeyReusePeriodSeconds` – Returns the length of time, in
#'     seconds, for which Amazon SQS can reuse a data key to encrypt or
#'     decrypt messages before calling KMS again. For more information, see
#'     [How Does the Data Key Reuse Period
#'     Work?](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work).
#' 
#' -   `SqsManagedSseEnabled` – Returns information about whether the queue
#'     is using SSE-SQS encryption using SQS owned encryption keys. Only
#'     one server-side encryption option is supported per queue (for
#'     example,
#'     [SSE-KMS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html)
#'     or
#'     [SSE-SQS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html)).
#' 
#' The following attributes apply only to [FIFO (first-in-first-out)
#' queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/):
#' 
#' -   `FifoQueue` – Returns information about whether the queue is FIFO.
#'     For more information, see [FIFO queue
#'     logic](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-understanding-logic.html)
#'     in the *Amazon SQS Developer Guide*.
#' 
#'     To determine whether a queue is
#'     [FIFO](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/),
#'     you can check whether `QueueName` ends with the `.fifo` suffix.
#' 
#' -   `ContentBasedDeduplication` – Returns whether content-based
#'     deduplication is enabled for the queue. For more information, see
#'     [Exactly-once
#'     processing](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html)
#'     in the *Amazon SQS Developer Guide*.
#' 
#' The following attributes apply only to [high throughput for FIFO
#' queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html):
#' 
#' -   `DeduplicationScope` – Specifies whether message deduplication
#'     occurs at the message group or queue level. Valid values are
#'     `messageGroup` and `queue`.
#' 
#' -   `FifoThroughputLimit` – Specifies whether the FIFO queue throughput
#'     quota applies to the entire queue or per message group. Valid values
#'     are `perQueue` and `perMessageGroupId`. The `perMessageGroupId`
#'     value is allowed only when the value for `DeduplicationScope` is
#'     `messageGroup`.
#' 
#' To enable high throughput for FIFO queues, do the following:
#' 
#' -   Set `DeduplicationScope` to `messageGroup`.
#' 
#' -   Set `FifoThroughputLimit` to `perMessageGroupId`.
#' 
#' If you set these attributes to anything other than the values shown for
#' enabling high throughput, normal throughput is in effect and
#' deduplication occurs as specified.
#' 
#' For information on throughput quotas, see [Quotas related to
#' messages](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html)
#' in the *Amazon SQS Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname sqs_get_queue_attributes
sqs_get_queue_attributes <- function(QueueUrl, AttributeNames = NULL) {
  op <- new_operation(
    name = "GetQueueAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$get_queue_attributes_input(QueueUrl = QueueUrl, AttributeNames = AttributeNames)
  output <- .sqs$get_queue_attributes_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$get_queue_attributes <- sqs_get_queue_attributes

#' Returns the URL of an existing Amazon SQS queue
#'
#' @description
#' Returns the URL of an existing Amazon SQS queue.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_get_queue_url/](https://www.paws-r-sdk.com/docs/sqs_get_queue_url/) for full documentation.
#'
#' @param QueueName &#91;required&#93; The name of the queue whose URL must be fetched. Maximum 80 characters.
#' Valid values: alphanumeric characters, hyphens (`-`), and underscores
#' (`_`).
#' 
#' Queue URLs and names are case-sensitive.
#' @param QueueOwnerAWSAccountId The Amazon Web Services account ID of the account that created the
#' queue.
#'
#' @keywords internal
#'
#' @rdname sqs_get_queue_url
sqs_get_queue_url <- function(QueueName, QueueOwnerAWSAccountId = NULL) {
  op <- new_operation(
    name = "GetQueueUrl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$get_queue_url_input(QueueName = QueueName, QueueOwnerAWSAccountId = QueueOwnerAWSAccountId)
  output <- .sqs$get_queue_url_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$get_queue_url <- sqs_get_queue_url

#' Returns a list of your queues that have the RedrivePolicy queue
#' attribute configured with a dead-letter queue
#'
#' @description
#' Returns a list of your queues that have the `RedrivePolicy` queue attribute configured with a dead-letter queue.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_list_dead_letter_source_queues/](https://www.paws-r-sdk.com/docs/sqs_list_dead_letter_source_queues/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of a dead-letter queue.
#' 
#' Queue URLs and names are case-sensitive.
#' @param NextToken Pagination token to request the next set of results.
#' @param MaxResults Maximum number of results to include in the response. Value range is 1
#' to 1000. You must set `MaxResults` to receive a value for `NextToken` in
#' the response.
#'
#' @keywords internal
#'
#' @rdname sqs_list_dead_letter_source_queues
sqs_list_dead_letter_source_queues <- function(QueueUrl, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDeadLetterSourceQueues",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "queueUrls")
  )
  input <- .sqs$list_dead_letter_source_queues_input(QueueUrl = QueueUrl, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sqs$list_dead_letter_source_queues_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$list_dead_letter_source_queues <- sqs_list_dead_letter_source_queues

#' Gets the most recent message movement tasks (up to 10) under a specific
#' source queue
#'
#' @description
#' Gets the most recent message movement tasks (up to 10) under a specific source queue.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_list_message_move_tasks/](https://www.paws-r-sdk.com/docs/sqs_list_message_move_tasks/) for full documentation.
#'
#' @param SourceArn &#91;required&#93; The ARN of the queue whose message movement tasks are to be listed.
#' @param MaxResults The maximum number of results to include in the response. The default is
#' 1, which provides the most recent message movement task. The upper limit
#' is 10.
#'
#' @keywords internal
#'
#' @rdname sqs_list_message_move_tasks
sqs_list_message_move_tasks <- function(SourceArn, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMessageMoveTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$list_message_move_tasks_input(SourceArn = SourceArn, MaxResults = MaxResults)
  output <- .sqs$list_message_move_tasks_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$list_message_move_tasks <- sqs_list_message_move_tasks

#' List all cost allocation tags added to the specified Amazon SQS queue
#'
#' @description
#' List all cost allocation tags added to the specified Amazon SQS queue. For an overview, see [Tagging Your Amazon SQS Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html) in the *Amazon SQS Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_list_queue_tags/](https://www.paws-r-sdk.com/docs/sqs_list_queue_tags/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the queue.
#'
#' @keywords internal
#'
#' @rdname sqs_list_queue_tags
sqs_list_queue_tags <- function(QueueUrl) {
  op <- new_operation(
    name = "ListQueueTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$list_queue_tags_input(QueueUrl = QueueUrl)
  output <- .sqs$list_queue_tags_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$list_queue_tags <- sqs_list_queue_tags

#' Returns a list of your queues in the current region
#'
#' @description
#' Returns a list of your queues in the current region. The response includes a maximum of 1,000 results. If you specify a value for the optional `QueueNamePrefix` parameter, only queues with a name that begins with the specified value are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_list_queues/](https://www.paws-r-sdk.com/docs/sqs_list_queues/) for full documentation.
#'
#' @param QueueNamePrefix A string to use for filtering the list results. Only those queues whose
#' name begins with the specified string are returned.
#' 
#' Queue URLs and names are case-sensitive.
#' @param NextToken Pagination token to request the next set of results.
#' @param MaxResults Maximum number of results to include in the response. Value range is 1
#' to 1000. You must set `MaxResults` to receive a value for `NextToken` in
#' the response.
#'
#' @keywords internal
#'
#' @rdname sqs_list_queues
sqs_list_queues <- function(QueueNamePrefix = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListQueues",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "QueueUrls")
  )
  input <- .sqs$list_queues_input(QueueNamePrefix = QueueNamePrefix, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sqs$list_queues_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$list_queues <- sqs_list_queues

#' Deletes available messages in a queue (including in-flight messages)
#' specified by the QueueURL parameter
#'
#' @description
#' Deletes available messages in a queue (including in-flight messages) specified by the `QueueURL` parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_purge_queue/](https://www.paws-r-sdk.com/docs/sqs_purge_queue/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the queue from which the [`purge_queue`][sqs_purge_queue]
#' action deletes messages.
#' 
#' Queue URLs and names are case-sensitive.
#'
#' @keywords internal
#'
#' @rdname sqs_purge_queue
sqs_purge_queue <- function(QueueUrl) {
  op <- new_operation(
    name = "PurgeQueue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$purge_queue_input(QueueUrl = QueueUrl)
  output <- .sqs$purge_queue_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$purge_queue <- sqs_purge_queue

#' Retrieves one or more messages (up to 10), from the specified queue
#'
#' @description
#' Retrieves one or more messages (up to 10), from the specified queue. Using the `WaitTimeSeconds` parameter enables long-poll support. For more information, see [Amazon SQS Long Polling](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-short-and-long-polling.html#sqs-long-polling) in the *Amazon SQS Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_receive_message/](https://www.paws-r-sdk.com/docs/sqs_receive_message/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue from which messages are received.
#' 
#' Queue URLs and names are case-sensitive.
#' @param AttributeNames A list of attributes that need to be returned along with each message.
#' These attributes include:
#' 
#' -   `All` – Returns all values.
#' 
#' -   `ApproximateFirstReceiveTimestamp` – Returns the time the message
#'     was first received from the queue ([epoch
#'     time](https://en.wikipedia.org/wiki/Unix_time) in milliseconds).
#' 
#' -   `ApproximateReceiveCount` – Returns the number of times a message
#'     has been received across all queues but not deleted.
#' 
#' -   `AWSTraceHeader` – Returns the X-Ray trace header string.
#' 
#' -   `SenderId`
#' 
#'     -   For a user, returns the user ID, for example
#'         `ABCDEFGHI1JKLMNOPQ23R`.
#' 
#'     -   For an IAM role, returns the IAM role ID, for example
#'         `ABCDE1F2GH3I4JK5LMNOP:i-a123b456`.
#' 
#' -   `SentTimestamp` – Returns the time the message was sent to the queue
#'     ([epoch time](https://en.wikipedia.org/wiki/Unix_time) in
#'     milliseconds).
#' 
#' -   `SqsManagedSseEnabled` – Enables server-side queue encryption using
#'     SQS owned encryption keys. Only one server-side encryption option is
#'     supported per queue (for example,
#'     [SSE-KMS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html)
#'     or
#'     [SSE-SQS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html)).
#' 
#' -   `MessageDeduplicationId` – Returns the value provided by the
#'     producer that calls the [`send_message`][sqs_send_message] action.
#' 
#' -   `MessageGroupId` – Returns the value provided by the producer that
#'     calls the [`send_message`][sqs_send_message] action. Messages with
#'     the same `MessageGroupId` are returned in sequence.
#' 
#' -   `SequenceNumber` – Returns the value provided by Amazon SQS.
#' @param MessageAttributeNames The name of the message attribute, where *N* is the index.
#' 
#' -   The name can contain alphanumeric characters and the underscore
#'     (`_`), hyphen (`-`), and period (`.`).
#' 
#' -   The name is case-sensitive and must be unique among all attribute
#'     names for the message.
#' 
#' -   The name must not start with AWS-reserved prefixes such as `AWS.` or
#'     `Amazon.` (or any casing variants).
#' 
#' -   The name must not start or end with a period (`.`), and it should
#'     not have periods in succession (`..`).
#' 
#' -   The name can be up to 256 characters long.
#' 
#' When using [`receive_message`][sqs_receive_message], you can send a list
#' of attribute names to receive, or you can return all of the attributes
#' by specifying `All` or `.*` in your request. You can also use all
#' message attributes starting with a prefix, for example `bar.*`.
#' @param MaxNumberOfMessages The maximum number of messages to return. Amazon SQS never returns more
#' messages than this value (however, fewer messages might be returned).
#' Valid values: 1 to 10. Default: 1.
#' @param VisibilityTimeout The duration (in seconds) that the received messages are hidden from
#' subsequent retrieve requests after being retrieved by a
#' [`receive_message`][sqs_receive_message] request.
#' @param WaitTimeSeconds The duration (in seconds) for which the call waits for a message to
#' arrive in the queue before returning. If a message is available, the
#' call returns sooner than `WaitTimeSeconds`. If no messages are available
#' and the wait time expires, the call returns successfully with an empty
#' list of messages.
#' 
#' To avoid HTTP errors, ensure that the HTTP response timeout for
#' [`receive_message`][sqs_receive_message] requests is longer than the
#' `WaitTimeSeconds` parameter. For example, with the Java SDK, you can set
#' HTTP transport settings using the
#' [NettyNioAsyncHttpClient](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/http/nio/netty/NettyNioAsyncHttpClient.html)
#' for asynchronous clients, or the
#' [ApacheHttpClient](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/http/apache/ApacheHttpClient.html)
#' for synchronous clients.
#' @param ReceiveRequestAttemptId This parameter applies only to FIFO (first-in-first-out) queues.
#' 
#' The token used for deduplication of
#' [`receive_message`][sqs_receive_message] calls. If a networking issue
#' occurs after a [`receive_message`][sqs_receive_message] action, and
#' instead of a response you receive a generic error, it is possible to
#' retry the same action with an identical `ReceiveRequestAttemptId` to
#' retrieve the same set of messages, even if their visibility timeout has
#' not yet expired.
#' 
#' -   You can use `ReceiveRequestAttemptId` only for 5 minutes after a
#'     [`receive_message`][sqs_receive_message] action.
#' 
#' -   When you set `FifoQueue`, a caller of the
#'     [`receive_message`][sqs_receive_message] action can provide a
#'     `ReceiveRequestAttemptId` explicitly.
#' 
#' -   If a caller of the [`receive_message`][sqs_receive_message] action
#'     doesn't provide a `ReceiveRequestAttemptId`, Amazon SQS generates a
#'     `ReceiveRequestAttemptId`.
#' 
#' -   It is possible to retry the [`receive_message`][sqs_receive_message]
#'     action with the same `ReceiveRequestAttemptId` if none of the
#'     messages have been modified (deleted or had their visibility
#'     changes).
#' 
#' -   During a visibility timeout, subsequent calls with the same
#'     `ReceiveRequestAttemptId` return the same messages and receipt
#'     handles. If a retry occurs within the deduplication interval, it
#'     resets the visibility timeout. For more information, see [Visibility
#'     Timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html)
#'     in the *Amazon SQS Developer Guide*.
#' 
#'     If a caller of the [`receive_message`][sqs_receive_message] action
#'     still processes messages when the visibility timeout expires and
#'     messages become visible, another worker consuming from the same
#'     queue can receive the same messages and therefore process
#'     duplicates. Also, if a consumer whose message processing time is
#'     longer than the visibility timeout tries to delete the processed
#'     messages, the action fails with an error.
#' 
#'     To mitigate this effect, ensure that your application observes a
#'     safe threshold before the visibility timeout expires and extend the
#'     visibility timeout as necessary.
#' 
#' -   While messages with a particular `MessageGroupId` are invisible, no
#'     more messages belonging to the same `MessageGroupId` are returned
#'     until the visibility timeout expires. You can still receive messages
#'     with another `MessageGroupId` as long as it is also visible.
#' 
#' -   If a caller of [`receive_message`][sqs_receive_message] can't track
#'     the `ReceiveRequestAttemptId`, no retries work until the original
#'     visibility timeout expires. As a result, delays might occur but the
#'     messages in the queue remain in a strict order.
#' 
#' The maximum length of `ReceiveRequestAttemptId` is 128 characters.
#' `ReceiveRequestAttemptId` can contain alphanumeric characters (`a-z`,
#' `A-Z`, `0-9`) and punctuation
#' (`` !\"#$%&\'()*+,-./:;<=>?@@[\]^_\`{|}~ ``).
#' 
#' For best practices of using `ReceiveRequestAttemptId`, see [Using the
#' ReceiveRequestAttemptId Request
#' Parameter](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-receiverequestattemptid-request-parameter.html)
#' in the *Amazon SQS Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname sqs_receive_message
sqs_receive_message <- function(QueueUrl, AttributeNames = NULL, MessageAttributeNames = NULL, MaxNumberOfMessages = NULL, VisibilityTimeout = NULL, WaitTimeSeconds = NULL, ReceiveRequestAttemptId = NULL) {
  op <- new_operation(
    name = "ReceiveMessage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$receive_message_input(QueueUrl = QueueUrl, AttributeNames = AttributeNames, MessageAttributeNames = MessageAttributeNames, MaxNumberOfMessages = MaxNumberOfMessages, VisibilityTimeout = VisibilityTimeout, WaitTimeSeconds = WaitTimeSeconds, ReceiveRequestAttemptId = ReceiveRequestAttemptId)
  output <- .sqs$receive_message_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$receive_message <- sqs_receive_message

#' Revokes any permissions in the queue policy that matches the specified
#' Label parameter
#'
#' @description
#' Revokes any permissions in the queue policy that matches the specified `Label` parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_remove_permission/](https://www.paws-r-sdk.com/docs/sqs_remove_permission/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue from which permissions are removed.
#' 
#' Queue URLs and names are case-sensitive.
#' @param Label &#91;required&#93; The identification of the permission to remove. This is the label added
#' using the [`add_permission`][sqs_add_permission] action.
#'
#' @keywords internal
#'
#' @rdname sqs_remove_permission
sqs_remove_permission <- function(QueueUrl, Label) {
  op <- new_operation(
    name = "RemovePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$remove_permission_input(QueueUrl = QueueUrl, Label = Label)
  output <- .sqs$remove_permission_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$remove_permission <- sqs_remove_permission

#' Delivers a message to the specified queue
#'
#' @description
#' Delivers a message to the specified queue.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_send_message/](https://www.paws-r-sdk.com/docs/sqs_send_message/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue to which a message is sent.
#' 
#' Queue URLs and names are case-sensitive.
#' @param MessageBody &#91;required&#93; The message to send. The minimum size is one character. The maximum size
#' is 256 KiB.
#' 
#' A message can include only XML, JSON, and unformatted text. The
#' following Unicode characters are allowed:
#' 
#' `#x9` | `#xA` | `#xD` | `#x20` to `#xD7FF` | `#xE000` to `#xFFFD` |
#' `#x10000` to `#x10FFFF`
#' 
#' Any characters not included in this list will be rejected. For more
#' information, see the [W3C specification for
#' characters](https://www.w3.org/TR/REC-xml/#charsets).
#' @param DelaySeconds The length of time, in seconds, for which to delay a specific message.
#' Valid values: 0 to 900. Maximum: 15 minutes. Messages with a positive
#' `DelaySeconds` value become available for processing after the delay
#' period is finished. If you don't specify a value, the default value for
#' the queue applies.
#' 
#' When you set `FifoQueue`, you can't set `DelaySeconds` per message. You
#' can set this parameter only on a queue level.
#' @param MessageAttributes Each message attribute consists of a `Name`, `Type`, and `Value`. For
#' more information, see [Amazon SQS message
#' attributes](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes)
#' in the *Amazon SQS Developer Guide*.
#' @param MessageSystemAttributes The message system attribute to send. Each message system attribute
#' consists of a `Name`, `Type`, and `Value`.
#' 
#' -   Currently, the only supported message system attribute is
#'     `AWSTraceHeader`. Its type must be `String` and its value must be a
#'     correctly formatted X-Ray trace header string.
#' 
#' -   The size of a message system attribute doesn't count towards the
#'     total size of a message.
#' @param MessageDeduplicationId This parameter applies only to FIFO (first-in-first-out) queues.
#' 
#' The token used for deduplication of sent messages. If a message with a
#' particular `MessageDeduplicationId` is sent successfully, any messages
#' sent with the same `MessageDeduplicationId` are accepted successfully
#' but aren't delivered during the 5-minute deduplication interval. For
#' more information, see [Exactly-once
#' processing](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html)
#' in the *Amazon SQS Developer Guide*.
#' 
#' -   Every message must have a unique `MessageDeduplicationId`,
#' 
#'     -   You may provide a `MessageDeduplicationId` explicitly.
#' 
#'     -   If you aren't able to provide a `MessageDeduplicationId` and you
#'         enable `ContentBasedDeduplication` for your queue, Amazon SQS
#'         uses a SHA-256 hash to generate the `MessageDeduplicationId`
#'         using the body of the message (but not the attributes of the
#'         message).
#' 
#'     -   If you don't provide a `MessageDeduplicationId` and the queue
#'         doesn't have `ContentBasedDeduplication` set, the action fails
#'         with an error.
#' 
#'     -   If the queue has `ContentBasedDeduplication` set, your
#'         `MessageDeduplicationId` overrides the generated one.
#' 
#' -   When `ContentBasedDeduplication` is in effect, messages with
#'     identical content sent within the deduplication interval are treated
#'     as duplicates and only one copy of the message is delivered.
#' 
#' -   If you send one message with `ContentBasedDeduplication` enabled and
#'     then another message with a `MessageDeduplicationId` that is the
#'     same as the one generated for the first `MessageDeduplicationId`,
#'     the two messages are treated as duplicates and only one copy of the
#'     message is delivered.
#' 
#' The `MessageDeduplicationId` is available to the consumer of the message
#' (this can be useful for troubleshooting delivery issues).
#' 
#' If a message is sent successfully but the acknowledgement is lost and
#' the message is resent with the same `MessageDeduplicationId` after the
#' deduplication interval, Amazon SQS can't detect duplicate messages.
#' 
#' Amazon SQS continues to keep track of the message deduplication ID even
#' after the message is received and deleted.
#' 
#' The maximum length of `MessageDeduplicationId` is 128 characters.
#' `MessageDeduplicationId` can contain alphanumeric characters (`a-z`,
#' `A-Z`, `0-9`) and punctuation
#' (`` !\"#$%&\'()*+,-./:;<=>?@@[\]^_\`{|}~ ``).
#' 
#' For best practices of using `MessageDeduplicationId`, see [Using the
#' MessageDeduplicationId
#' Property](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html)
#' in the *Amazon SQS Developer Guide*.
#' @param MessageGroupId This parameter applies only to FIFO (first-in-first-out) queues.
#' 
#' The tag that specifies that a message belongs to a specific message
#' group. Messages that belong to the same message group are processed in a
#' FIFO manner (however, messages in different message groups might be
#' processed out of order). To interleave multiple ordered streams within a
#' single queue, use `MessageGroupId` values (for example, session data for
#' multiple users). In this scenario, multiple consumers can process the
#' queue, but the session data of each user is processed in a FIFO fashion.
#' 
#' -   You must associate a non-empty `MessageGroupId` with a message. If
#'     you don't provide a `MessageGroupId`, the action fails.
#' 
#' -   [`receive_message`][sqs_receive_message] might return messages with
#'     multiple `MessageGroupId` values. For each `MessageGroupId`, the
#'     messages are sorted by time sent. The caller can't specify a
#'     `MessageGroupId`.
#' 
#' The length of `MessageGroupId` is 128 characters. Valid values:
#' alphanumeric characters and punctuation
#' `` (!\"#$%&\'()*+,-./:;<=>?@@[\]^_\`{|}~) ``.
#' 
#' For best practices of using `MessageGroupId`, see [Using the
#' MessageGroupId
#' Property](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagegroupid-property.html)
#' in the *Amazon SQS Developer Guide*.
#' 
#' `MessageGroupId` is required for FIFO queues. You can't use it for
#' Standard queues.
#'
#' @keywords internal
#'
#' @rdname sqs_send_message
sqs_send_message <- function(QueueUrl, MessageBody, DelaySeconds = NULL, MessageAttributes = NULL, MessageSystemAttributes = NULL, MessageDeduplicationId = NULL, MessageGroupId = NULL) {
  op <- new_operation(
    name = "SendMessage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$send_message_input(QueueUrl = QueueUrl, MessageBody = MessageBody, DelaySeconds = DelaySeconds, MessageAttributes = MessageAttributes, MessageSystemAttributes = MessageSystemAttributes, MessageDeduplicationId = MessageDeduplicationId, MessageGroupId = MessageGroupId)
  output <- .sqs$send_message_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$send_message <- sqs_send_message

#' You can use SendMessageBatch to send up to 10 messages to the specified
#' queue by assigning either identical or different values to each message
#' (or by not assigning values at all)
#'
#' @description
#' You can use [`send_message_batch`][sqs_send_message_batch] to send up to 10 messages to the specified queue by assigning either identical or different values to each message (or by not assigning values at all). This is a batch version of ` SendMessage.` For a FIFO queue, multiple messages within a single batch are enqueued in the order they are sent.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_send_message_batch/](https://www.paws-r-sdk.com/docs/sqs_send_message_batch/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue to which batched messages are sent.
#' 
#' Queue URLs and names are case-sensitive.
#' @param Entries &#91;required&#93; A list of ` SendMessageBatchRequestEntry ` items.
#'
#' @keywords internal
#'
#' @rdname sqs_send_message_batch
sqs_send_message_batch <- function(QueueUrl, Entries) {
  op <- new_operation(
    name = "SendMessageBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$send_message_batch_input(QueueUrl = QueueUrl, Entries = Entries)
  output <- .sqs$send_message_batch_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$send_message_batch <- sqs_send_message_batch

#' Sets the value of one or more queue attributes
#'
#' @description
#' Sets the value of one or more queue attributes. When you change a queue's attributes, the change can take up to 60 seconds for most of the attributes to propagate throughout the Amazon SQS system. Changes made to the `MessageRetentionPeriod` attribute can take up to 15 minutes and will impact existing messages in the queue potentially causing them to be expired and deleted if the `MessageRetentionPeriod` is reduced below the age of existing messages.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_set_queue_attributes/](https://www.paws-r-sdk.com/docs/sqs_set_queue_attributes/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the Amazon SQS queue whose attributes are set.
#' 
#' Queue URLs and names are case-sensitive.
#' @param Attributes &#91;required&#93; A map of attributes to set.
#' 
#' The following lists the names, descriptions, and values of the special
#' request parameters that the
#' [`set_queue_attributes`][sqs_set_queue_attributes] action uses:
#' 
#' -   `DelaySeconds` – The length of time, in seconds, for which the
#'     delivery of all messages in the queue is delayed. Valid values: An
#'     integer from 0 to 900 (15 minutes). Default: 0.
#' 
#' -   `MaximumMessageSize` – The limit of how many bytes a message can
#'     contain before Amazon SQS rejects it. Valid values: An integer from
#'     1,024 bytes (1 KiB) up to 262,144 bytes (256 KiB). Default: 262,144
#'     (256 KiB).
#' 
#' -   `MessageRetentionPeriod` – The length of time, in seconds, for which
#'     Amazon SQS retains a message. Valid values: An integer representing
#'     seconds, from 60 (1 minute) to 1,209,600 (14 days). Default: 345,600
#'     (4 days). When you change a queue's attributes, the change can take
#'     up to 60 seconds for most of the attributes to propagate throughout
#'     the Amazon SQS system. Changes made to the `MessageRetentionPeriod`
#'     attribute can take up to 15 minutes and will impact existing
#'     messages in the queue potentially causing them to be expired and
#'     deleted if the `MessageRetentionPeriod` is reduced below the age of
#'     existing messages.
#' 
#' -   `Policy` – The queue's policy. A valid Amazon Web Services policy.
#'     For more information about policy structure, see [Overview of Amazon
#'     Web Services IAM
#'     Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html)
#'     in the *Identity and Access Management User Guide*.
#' 
#' -   `ReceiveMessageWaitTimeSeconds` – The length of time, in seconds,
#'     for which a [`receive_message`][sqs_receive_message] action waits
#'     for a message to arrive. Valid values: An integer from 0 to 20
#'     (seconds). Default: 0.
#' 
#' -   `VisibilityTimeout` – The visibility timeout for the queue, in
#'     seconds. Valid values: An integer from 0 to 43,200 (12 hours).
#'     Default: 30. For more information about the visibility timeout, see
#'     [Visibility
#'     Timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html)
#'     in the *Amazon SQS Developer Guide*.
#' 
#' The following attributes apply only to [dead-letter
#' queues:](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html)
#' 
#' -   `RedrivePolicy` – The string that includes the parameters for the
#'     dead-letter queue functionality of the source queue as a JSON
#'     object. The parameters are as follows:
#' 
#'     -   `deadLetterTargetArn` – The Amazon Resource Name (ARN) of the
#'         dead-letter queue to which Amazon SQS moves messages after the
#'         value of `maxReceiveCount` is exceeded.
#' 
#'     -   `maxReceiveCount` – The number of times a message is delivered
#'         to the source queue before being moved to the dead-letter queue.
#'         Default: 10. When the `ReceiveCount` for a message exceeds the
#'         `maxReceiveCount` for a queue, Amazon SQS moves the message to
#'         the dead-letter-queue.
#' 
#' -   `RedriveAllowPolicy` – The string that includes the parameters for
#'     the permissions for the dead-letter queue redrive permission and
#'     which source queues can specify dead-letter queues as a JSON object.
#'     The parameters are as follows:
#' 
#'     -   `redrivePermission` – The permission type that defines which
#'         source queues can specify the current queue as the dead-letter
#'         queue. Valid values are:
#' 
#'         -   `allowAll` – (Default) Any source queues in this Amazon Web
#'             Services account in the same Region can specify this queue
#'             as the dead-letter queue.
#' 
#'         -   `denyAll` – No source queues can specify this queue as the
#'             dead-letter queue.
#' 
#'         -   `byQueue` – Only queues specified by the `sourceQueueArns`
#'             parameter can specify this queue as the dead-letter queue.
#' 
#'     -   `sourceQueueArns` – The Amazon Resource Names (ARN)s of the
#'         source queues that can specify this queue as the dead-letter
#'         queue and redrive messages. You can specify this parameter only
#'         when the `redrivePermission` parameter is set to `byQueue`. You
#'         can specify up to 10 source queue ARNs. To allow more than 10
#'         source queues to specify dead-letter queues, set the
#'         `redrivePermission` parameter to `allowAll`.
#' 
#' The dead-letter queue of a FIFO queue must also be a FIFO queue.
#' Similarly, the dead-letter queue of a standard queue must also be a
#' standard queue.
#' 
#' The following attributes apply only to
#' [server-side-encryption](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html):
#' 
#' -   `KmsMasterKeyId` – The ID of an Amazon Web Services managed customer
#'     master key (CMK) for Amazon SQS or a custom CMK. For more
#'     information, see [Key
#'     Terms](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms).
#'     While the alias of the AWS-managed CMK for Amazon SQS is always
#'     `alias/aws/sqs`, the alias of a custom CMK can, for example, be
#'     `alias/MyAlias `. For more examples, see
#'     [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters)
#'     in the *Key Management Service API Reference*.
#' 
#' -   `KmsDataKeyReusePeriodSeconds` – The length of time, in seconds, for
#'     which Amazon SQS can reuse a [data
#'     key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-keys)
#'     to encrypt or decrypt messages before calling KMS again. An integer
#'     representing seconds, between 60 seconds (1 minute) and 86,400
#'     seconds (24 hours). Default: 300 (5 minutes). A shorter time period
#'     provides better security but results in more calls to KMS which
#'     might incur charges after Free Tier. For more information, see [How
#'     Does the Data Key Reuse Period
#'     Work?](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work).
#' 
#' -   `SqsManagedSseEnabled` – Enables server-side queue encryption using
#'     SQS owned encryption keys. Only one server-side encryption option is
#'     supported per queue (for example,
#'     [SSE-KMS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html)
#'     or
#'     [SSE-SQS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html)).
#' 
#' The following attribute applies only to [FIFO (first-in-first-out)
#' queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/):
#' 
#' -   `ContentBasedDeduplication` – Enables content-based deduplication.
#'     For more information, see [Exactly-once
#'     processing](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html)
#'     in the *Amazon SQS Developer Guide*. Note the following:
#' 
#'     -   Every message must have a unique `MessageDeduplicationId`.
#' 
#'         -   You may provide a `MessageDeduplicationId` explicitly.
#' 
#'         -   If you aren't able to provide a `MessageDeduplicationId` and
#'             you enable `ContentBasedDeduplication` for your queue,
#'             Amazon SQS uses a SHA-256 hash to generate the
#'             `MessageDeduplicationId` using the body of the message (but
#'             not the attributes of the message).
#' 
#'         -   If you don't provide a `MessageDeduplicationId` and the
#'             queue doesn't have `ContentBasedDeduplication` set, the
#'             action fails with an error.
#' 
#'         -   If the queue has `ContentBasedDeduplication` set, your
#'             `MessageDeduplicationId` overrides the generated one.
#' 
#'     -   When `ContentBasedDeduplication` is in effect, messages with
#'         identical content sent within the deduplication interval are
#'         treated as duplicates and only one copy of the message is
#'         delivered.
#' 
#'     -   If you send one message with `ContentBasedDeduplication` enabled
#'         and then another message with a `MessageDeduplicationId` that is
#'         the same as the one generated for the first
#'         `MessageDeduplicationId`, the two messages are treated as
#'         duplicates and only one copy of the message is delivered.
#' 
#' The following attributes apply only to [high throughput for FIFO
#' queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html):
#' 
#' -   `DeduplicationScope` – Specifies whether message deduplication
#'     occurs at the message group or queue level. Valid values are
#'     `messageGroup` and `queue`.
#' 
#' -   `FifoThroughputLimit` – Specifies whether the FIFO queue throughput
#'     quota applies to the entire queue or per message group. Valid values
#'     are `perQueue` and `perMessageGroupId`. The `perMessageGroupId`
#'     value is allowed only when the value for `DeduplicationScope` is
#'     `messageGroup`.
#' 
#' To enable high throughput for FIFO queues, do the following:
#' 
#' -   Set `DeduplicationScope` to `messageGroup`.
#' 
#' -   Set `FifoThroughputLimit` to `perMessageGroupId`.
#' 
#' If you set these attributes to anything other than the values shown for
#' enabling high throughput, normal throughput is in effect and
#' deduplication occurs as specified.
#' 
#' For information on throughput quotas, see [Quotas related to
#' messages](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html)
#' in the *Amazon SQS Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname sqs_set_queue_attributes
sqs_set_queue_attributes <- function(QueueUrl, Attributes) {
  op <- new_operation(
    name = "SetQueueAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$set_queue_attributes_input(QueueUrl = QueueUrl, Attributes = Attributes)
  output <- .sqs$set_queue_attributes_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$set_queue_attributes <- sqs_set_queue_attributes

#' Starts an asynchronous task to move messages from a specified source
#' queue to a specified destination queue
#'
#' @description
#' Starts an asynchronous task to move messages from a specified source queue to a specified destination queue.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_start_message_move_task/](https://www.paws-r-sdk.com/docs/sqs_start_message_move_task/) for full documentation.
#'
#' @param SourceArn &#91;required&#93; The ARN of the queue that contains the messages to be moved to another
#' queue. Currently, only ARNs of dead-letter queues (DLQs) whose sources
#' are other Amazon SQS queues are accepted. DLQs whose sources are non-SQS
#' queues, such as Lambda or Amazon SNS topics, are not currently
#' supported.
#' @param DestinationArn The ARN of the queue that receives the moved messages. You can use this
#' field to specify the destination queue where you would like to redrive
#' messages. If this field is left blank, the messages will be redriven
#' back to their respective original source queues.
#' @param MaxNumberOfMessagesPerSecond The number of messages to be moved per second (the message movement
#' rate). You can use this field to define a fixed message movement rate.
#' The maximum value for messages per second is 500. If this field is left
#' blank, the system will optimize the rate based on the queue message
#' backlog size, which may vary throughout the duration of the message
#' movement task.
#'
#' @keywords internal
#'
#' @rdname sqs_start_message_move_task
sqs_start_message_move_task <- function(SourceArn, DestinationArn = NULL, MaxNumberOfMessagesPerSecond = NULL) {
  op <- new_operation(
    name = "StartMessageMoveTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$start_message_move_task_input(SourceArn = SourceArn, DestinationArn = DestinationArn, MaxNumberOfMessagesPerSecond = MaxNumberOfMessagesPerSecond)
  output <- .sqs$start_message_move_task_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$start_message_move_task <- sqs_start_message_move_task

#' Add cost allocation tags to the specified Amazon SQS queue
#'
#' @description
#' Add cost allocation tags to the specified Amazon SQS queue. For an overview, see [Tagging Your Amazon SQS Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html) in the *Amazon SQS Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_tag_queue/](https://www.paws-r-sdk.com/docs/sqs_tag_queue/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the queue.
#' @param Tags &#91;required&#93; The list of tags to be added to the specified queue.
#'
#' @keywords internal
#'
#' @rdname sqs_tag_queue
sqs_tag_queue <- function(QueueUrl, Tags) {
  op <- new_operation(
    name = "TagQueue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$tag_queue_input(QueueUrl = QueueUrl, Tags = Tags)
  output <- .sqs$tag_queue_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$tag_queue <- sqs_tag_queue

#' Remove cost allocation tags from the specified Amazon SQS queue
#'
#' @description
#' Remove cost allocation tags from the specified Amazon SQS queue. For an overview, see [Tagging Your Amazon SQS Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html) in the *Amazon SQS Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/sqs_untag_queue/](https://www.paws-r-sdk.com/docs/sqs_untag_queue/) for full documentation.
#'
#' @param QueueUrl &#91;required&#93; The URL of the queue.
#' @param TagKeys &#91;required&#93; The list of tags to be removed from the specified queue.
#'
#' @keywords internal
#'
#' @rdname sqs_untag_queue
sqs_untag_queue <- function(QueueUrl, TagKeys) {
  op <- new_operation(
    name = "UntagQueue",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sqs$untag_queue_input(QueueUrl = QueueUrl, TagKeys = TagKeys)
  output <- .sqs$untag_queue_output()
  config <- get_config()
  svc <- .sqs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sqs$operations$untag_queue <- sqs_untag_queue
