# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Simple Queue Service
#'
#' @description
#' Welcome to the *Amazon SQS API Reference*.
#' 
#' Amazon SQS is a reliable, highly-scalable hosted queue for storing
#' messages as they travel between applications or microservices. Amazon
#' SQS moves data between distributed application components and helps you
#' decouple these components.
#' 
#' For information on the permissions you need to use this API, see
#' [Identity and access
#' management](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-authentication-and-access-control.html)
#' in the *Amazon SQS Developer Guide.*
#' 
#' You can use [Amazon Web Services
#' SDKs](https://aws.amazon.com/developer/tools/#sdk) to access Amazon SQS
#' using your favorite programming language. The SDKs perform tasks such as
#' the following automatically:
#' 
#' -   Cryptographically sign your service requests
#' 
#' -   Retry requests
#' 
#' -   Handle error responses
#' 
#' **Additional information**
#' 
#' -   [Amazon SQS Product Page](https://aws.amazon.com/sqs/)
#' 
#' -   *Amazon SQS Developer Guide*
#' 
#'     -   [Making API
#'         Requests](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests-xml.html)
#' 
#'     -   [Amazon SQS Message
#'         Attributes](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes)
#' 
#'     -   [Amazon SQS Dead-Letter
#'         Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html)
#' 
#' -   [Amazon SQS in the *Command Line
#'     Interface*](https://docs.aws.amazon.com/cli/latest/reference/sqs/)
#' 
#' -   *Amazon Web Services General Reference*
#' 
#'     -   [Regions and
#'         Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#sqs_region)
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- sqs(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- sqs()
#' svc$add_permission(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=sqs_add_permission]{add_permission} \tab Adds a permission to a queue for a specific principal\cr
#'  \link[=sqs_cancel_message_move_task]{cancel_message_move_task} \tab Cancels a specified message movement task\cr
#'  \link[=sqs_change_message_visibility]{change_message_visibility} \tab Changes the visibility timeout of a specified message in a queue to a new value\cr
#'  \link[=sqs_change_message_visibility_batch]{change_message_visibility_batch} \tab Changes the visibility timeout of multiple messages\cr
#'  \link[=sqs_create_queue]{create_queue} \tab Creates a new standard or FIFO queue\cr
#'  \link[=sqs_delete_message]{delete_message} \tab Deletes the specified message from the specified queue\cr
#'  \link[=sqs_delete_message_batch]{delete_message_batch} \tab Deletes up to ten messages from the specified queue\cr
#'  \link[=sqs_delete_queue]{delete_queue} \tab Deletes the queue specified by the QueueUrl, regardless of the queue's contents\cr
#'  \link[=sqs_get_queue_attributes]{get_queue_attributes} \tab Gets attributes for the specified queue\cr
#'  \link[=sqs_get_queue_url]{get_queue_url} \tab Returns the URL of an existing Amazon SQS queue\cr
#'  \link[=sqs_list_dead_letter_source_queues]{list_dead_letter_source_queues} \tab Returns a list of your queues that have the RedrivePolicy queue attribute configured with a dead-letter queue\cr
#'  \link[=sqs_list_message_move_tasks]{list_message_move_tasks} \tab Gets the most recent message movement tasks (up to 10) under a specific source queue\cr
#'  \link[=sqs_list_queues]{list_queues} \tab Returns a list of your queues in the current region\cr
#'  \link[=sqs_list_queue_tags]{list_queue_tags} \tab List all cost allocation tags added to the specified Amazon SQS queue\cr
#'  \link[=sqs_purge_queue]{purge_queue} \tab Deletes available messages in a queue (including in-flight messages) specified by the QueueURL parameter\cr
#'  \link[=sqs_receive_message]{receive_message} \tab Retrieves one or more messages (up to 10), from the specified queue\cr
#'  \link[=sqs_remove_permission]{remove_permission} \tab Revokes any permissions in the queue policy that matches the specified Label parameter\cr
#'  \link[=sqs_send_message]{send_message} \tab Delivers a message to the specified queue\cr
#'  \link[=sqs_send_message_batch]{send_message_batch} \tab You can use SendMessageBatch to send up to 10 messages to the specified queue by assigning either identical or different values to each message (or by not assigning values at all)\cr
#'  \link[=sqs_set_queue_attributes]{set_queue_attributes} \tab Sets the value of one or more queue attributes\cr
#'  \link[=sqs_start_message_move_task]{start_message_move_task} \tab Starts an asynchronous task to move messages from a specified source queue to a specified destination queue\cr
#'  \link[=sqs_tag_queue]{tag_queue} \tab Add cost allocation tags to the specified Amazon SQS queue\cr
#'  \link[=sqs_untag_queue]{untag_queue} \tab Remove cost allocation tags from the specified Amazon SQS queue
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname sqs
#' @export
sqs <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .sqs$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.sqs <- list()

.sqs$operations <- list()

.sqs$metadata <- list(
  service_name = "sqs",
  endpoints = list("*" = list(endpoint = "sqs.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "sqs.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "sqs.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "sqs.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "sqs.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "sqs.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "SQS",
  api_version = "2012-11-05",
  signing_name = "sqs",
  json_version = "1.0",
  target_prefix = "AmazonSQS"
)

.sqs$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.sqs$metadata, handlers, config)
}
