% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_operations.R
\name{locationservice_forecast_geofence_events}
\alias{locationservice_forecast_geofence_events}
\title{Evaluates device positions against geofence geometries from a given
geofence collection}
\usage{
locationservice_forecast_geofence_events(
  CollectionName,
  DeviceState,
  TimeHorizonMinutes = NULL,
  DistanceUnit = NULL,
  SpeedUnit = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{CollectionName}{[required] The name of the geofence collection.}

\item{DeviceState}{[required] The device's state, including current position and speed.}

\item{TimeHorizonMinutes}{Specifies the time horizon in minutes for the forecasted events.}

\item{DistanceUnit}{The distance unit used for the \code{NearestDistance} property returned in a
forecasted event. The measurement system must match for \code{DistanceUnit}
and \code{SpeedUnit}; if \code{Kilometers} is specified for \code{DistanceUnit}, then
\code{SpeedUnit} must be \code{KilometersPerHour}.

Default Value: \code{Kilometers}}

\item{SpeedUnit}{The speed unit for the device captured by the device state. The
measurement system must match for \code{DistanceUnit} and \code{SpeedUnit}; if
\code{Kilometers} is specified for \code{DistanceUnit}, then \code{SpeedUnit} must be
\code{KilometersPerHour}.

Default Value: \code{KilometersPerHour}.}

\item{NextToken}{The pagination token specifying which page of results to return in the
response. If no token is provided, the default page is the first page.

Default value: \code{null}}

\item{MaxResults}{An optional limit for the number of resources returned in a single call.

Default value: \code{20}}
}
\description{
Evaluates device positions against geofence geometries from a given geofence collection. The event forecasts three states for which a device can be in relative to a geofence:

See \url{https://www.paws-r-sdk.com/docs/locationservice_forecast_geofence_events/} for full documentation.
}
\keyword{internal}
