% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error.R
\name{aws_error}
\alias{aws_error}
\title{Generate a classed http error}
\usage{
aws_error(e, call = sys.call(-1), use_call = FALSE)
}
\arguments{
\item{e}{An error struct, like ones generated by \code{paws::Error}.
Must contain fields \code{code} (string),\code{message} (string),
\code{status_code} (numeric), \code{error_response} (list).}

\item{call}{The call stored in the condition object.}
}
\value{
An S3 object that inherits from (e.g.) condition, error,
http_error, http_400 and http_404.
}
\description{
This function generates S3 error objects which are passed to
\code{\link[=stop]{stop()}} to generate classed errors.
These can be used in conjunction with \code{\link[=tryCatch]{tryCatch()}}
to respond differently to different types of failure.
}
\details{
This expands on the condition messages generated by the httr package
in \code{httr::http_condition()}. In addition to error classes like
\code{http_error}, \code{http_400}, and \code{http_404}, this sets attributes
on the error condition that contain the unmarshaled error
reponse from AWS for the respective service.
}
\seealso{
\url{http://adv-r.had.co.nz/Exceptions-Debugging.html#condition-handling}
for more details about R's condition handling model
https://github.com/r-lib/httr/blob/master/R/response-status.r#L310
for the httr inspiration of this condition
}
\keyword{internal}
