% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_provision_byoip_cidr}
\alias{ec2_provision_byoip_cidr}
\title{Provisions an IPv4 or IPv6 address range for use with your AWS resources
through bring your own IP addresses (BYOIP) and creates a corresponding
address pool}
\usage{
ec2_provision_byoip_cidr(Cidr, CidrAuthorizationContext,
  PubliclyAdvertisable, Description, DryRun, PoolTagSpecifications)
}
\arguments{
\item{Cidr}{[required] The public IPv4 or IPv6 address range, in CIDR notation. The most
specific IPv4 prefix that you can specify is /24. The most specific IPv6
prefix you can specify is /56. The address range cannot overlap with
another address range that you've brought to this or another Region.}

\item{CidrAuthorizationContext}{A signed document that proves that you are authorized to bring the
specified IP address range to Amazon using BYOIP.}

\item{PubliclyAdvertisable}{(IPv6 only) Indicate whether the address range will be publicly
advertised to the internet.

Default: true}

\item{Description}{A description for the address range and the address pool.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{PoolTagSpecifications}{The tags to apply to the address pool.}
}
\description{
Provisions an IPv4 or IPv6 address range for use with your AWS resources
through bring your own IP addresses (BYOIP) and creates a corresponding
address pool. After the address range is provisioned, it is ready to be
advertised using AdvertiseByoipCidr.

AWS verifies that you own the address range and are authorized to
advertise it. You must ensure that the address range is registered to
you and that you created an RPKI ROA to authorize Amazon ASNs 16509 and
14618 to advertise the address range. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html}{Bring Your Own IP Addresses (BYOIP)}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

Provisioning an address range is an asynchronous operation, so the call
returns immediately, but the address range is not ready to use until its
status changes from \code{pending-provision} to \code{provisioned}. To monitor the
status of an address range, use DescribeByoipCidrs. To allocate an
Elastic IP address from your IPv4 address pool, use AllocateAddress with
either the specific address from the address pool or the ID of the
address pool.
}
\section{Request syntax}{
\preformatted{svc$provision_byoip_cidr(
  Cidr = "string",
  CidrAuthorizationContext = list(
    Message = "string",
    Signature = "string"
  ),
  PubliclyAdvertisable = TRUE|FALSE,
  Description = "string",
  DryRun = TRUE|FALSE,
  PoolTagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
