% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_attach_disk}
\alias{lightsail_attach_disk}
\title{Attaches a block storage disk to a running or stopped Lightsail instance
and exposes it to the instance with the specified disk name}
\usage{
lightsail_attach_disk(diskName, instanceName, diskPath)
}
\arguments{
\item{diskName}{[required] The unique Lightsail disk name (e.g., \code{my-disk}).}

\item{instanceName}{[required] The name of the Lightsail instance where you want to utilize the storage
disk.}

\item{diskPath}{[required] The disk path to expose to the instance (e.g., \verb{/dev/xvdf}).}
}
\description{
Attaches a block storage disk to a running or stopped Lightsail instance
and exposes it to the instance with the specified disk name.

The \verb{attach disk} operation supports tag-based access control via
resource tags applied to the resource identified by \verb{disk name}. For
more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$attach_disk(
  diskName = "string",
  instanceName = "string",
  diskPath = "string"
)
}
}

\keyword{internal}
