% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serverlessapplicationrepository_operations.R
\name{serverlessapplicationrepository_get_application}
\alias{serverlessapplicationrepository_get_application}
\title{Gets the specified application}
\usage{
serverlessapplicationrepository_get_application(ApplicationId,
  SemanticVersion)
}
\arguments{
\item{ApplicationId}{[required] The Amazon Resource Name (ARN) of the application.}

\item{SemanticVersion}{The semantic version of the application to get.}
}
\value{
A list with the following syntax:\preformatted{list(
  ApplicationId = "string",
  Author = "string",
  CreationTime = "string",
  Description = "string",
  HomePageUrl = "string",
  IsVerifiedAuthor = TRUE|FALSE,
  Labels = list(
    "string"
  ),
  LicenseUrl = "string",
  Name = "string",
  ReadmeUrl = "string",
  SpdxLicenseId = "string",
  VerifiedAuthorUrl = "string",
  Version = list(
    ApplicationId = "string",
    CreationTime = "string",
    ParameterDefinitions = list(
      list(
        AllowedPattern = "string",
        AllowedValues = list(
          "string"
        ),
        ConstraintDescription = "string",
        DefaultValue = "string",
        Description = "string",
        MaxLength = 123,
        MaxValue = 123,
        MinLength = 123,
        MinValue = 123,
        Name = "string",
        NoEcho = TRUE|FALSE,
        ReferencedByResources = list(
          "string"
        ),
        Type = "string"
      )
    ),
    RequiredCapabilities = list(
      "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"|"CAPABILITY_RESOURCE_POLICY"
    ),
    ResourcesSupported = TRUE|FALSE,
    SemanticVersion = "string",
    SourceCodeArchiveUrl = "string",
    SourceCodeUrl = "string",
    TemplateUrl = "string"
  )
)
}
}
\description{
Gets the specified application.
}
\section{Request syntax}{
\preformatted{svc$get_application(
  ApplicationId = "string",
  SemanticVersion = "string"
)
}
}

\keyword{internal}
