% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpc_endpoint_service_configuration}
\alias{ec2_create_vpc_endpoint_service_configuration}
\title{Creates a VPC endpoint service configuration to which service consumers
(AWS accounts, IAM users, and IAM roles) can connect}
\usage{
ec2_create_vpc_endpoint_service_configuration(DryRun,
  AcceptanceRequired, PrivateDnsName, NetworkLoadBalancerArns,
  GatewayLoadBalancerArns, ClientToken, TagSpecifications)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{AcceptanceRequired}{Indicates whether requests from service consumers to create an endpoint
to your service must be accepted. To accept a request, use
\code{\link[=ec2_accept_vpc_endpoint_connections]{accept_vpc_endpoint_connections}}.}

\item{PrivateDnsName}{(Interface endpoint configuration) The private DNS name to assign to the
VPC endpoint service.}

\item{NetworkLoadBalancerArns}{The Amazon Resource Names (ARNs) of one or more Network Load Balancers
for your service.}

\item{GatewayLoadBalancerArns}{The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}

\item{TagSpecifications}{The tags to associate with the service.}
}
\value{
A list with the following syntax:\preformatted{list(
  ServiceConfiguration = list(
    ServiceType = list(
      list(
        ServiceType = "Interface"|"Gateway"|"GatewayLoadBalancer"
      )
    ),
    ServiceId = "string",
    ServiceName = "string",
    ServiceState = "Pending"|"Available"|"Deleting"|"Deleted"|"Failed",
    AvailabilityZones = list(
      "string"
    ),
    AcceptanceRequired = TRUE|FALSE,
    ManagesVpcEndpoints = TRUE|FALSE,
    NetworkLoadBalancerArns = list(
      "string"
    ),
    GatewayLoadBalancerArns = list(
      "string"
    ),
    BaseEndpointDnsNames = list(
      "string"
    ),
    PrivateDnsName = "string",
    PrivateDnsNameConfiguration = list(
      State = "pendingVerification"|"verified"|"failed",
      Type = "string",
      Value = "string",
      Name = "string"
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  ),
  ClientToken = "string"
)
}
}
\description{
Creates a VPC endpoint service configuration to which service consumers
(AWS accounts, IAM users, and IAM roles) can connect.

To create an endpoint service configuration, you must first create one
of the following for your service:
\itemize{
\item A \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/introduction.html}{Network Load Balancer}.
Service consumers connect to your service using an interface
endpoint.
\item A \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/introduction.html}{Gateway Load Balancer}.
Service consumers connect to your service using a Gateway Load
Balancer endpoint.
}

For more information, see \href{https://docs.aws.amazon.com/vpc/latest/privatelink/endpoint-service.html}{VPC Endpoint Services}
in the \emph{Amazon Virtual Private Cloud User Guide}.

If you set the private DNS name, you must prove that you own the private
DNS domain name. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/privatelink/endpoint-services-dns-validation.html}{VPC Endpoint Service Private DNS Name Verification}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_vpc_endpoint_service_configuration(
  DryRun = TRUE|FALSE,
  AcceptanceRequired = TRUE|FALSE,
  PrivateDnsName = "string",
  NetworkLoadBalancerArns = list(
    "string"
  ),
  GatewayLoadBalancerArns = list(
    "string"
  ),
  ClientToken = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
