% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_transit_gateway_connect_peers}
\alias{ec2_describe_transit_gateway_connect_peers}
\title{Describes one or more Connect peers}
\usage{
ec2_describe_transit_gateway_connect_peers(TransitGatewayConnectPeerIds,
  Filters, MaxResults, NextToken, DryRun)
}
\arguments{
\item{TransitGatewayConnectPeerIds}{The IDs of the Connect peers.}

\item{Filters}{One or more filters. The possible values are:
\itemize{
\item \code{state} - The state of the Connect peer (\code{pending} | \code{available} |
\code{deleting} | \code{deleted}).
\item \code{transit-gateway-attachment-id} - The ID of the attachment.
\item \code{transit-gateway-connect-peer-id} - The ID of the Connect peer.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  TransitGatewayConnectPeers = list(
    list(
      TransitGatewayAttachmentId = "string",
      TransitGatewayConnectPeerId = "string",
      State = "pending"|"available"|"deleting"|"deleted",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      ConnectPeerConfiguration = list(
        TransitGatewayAddress = "string",
        PeerAddress = "string",
        InsideCidrBlocks = list(
          "string"
        ),
        Protocol = "gre",
        BgpConfigurations = list(
          list(
            TransitGatewayAsn = 123,
            PeerAsn = 123,
            TransitGatewayAddress = "string",
            PeerAddress = "string",
            BgpStatus = "up"|"down"
          )
        )
      ),
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes one or more Connect peers.
}
\section{Request syntax}{
\preformatted{svc$describe_transit_gateway_connect_peers(
  TransitGatewayConnectPeerIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
