% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serverlessapplicationrepository_operations.R
\name{serverlessapplicationrepository_create_application_version}
\alias{serverlessapplicationrepository_create_application_version}
\title{Creates an application version}
\usage{
serverlessapplicationrepository_create_application_version(
  ApplicationId, SemanticVersion, SourceCodeArchiveUrl, SourceCodeUrl,
  TemplateBody, TemplateUrl)
}
\arguments{
\item{ApplicationId}{[required] The Amazon Resource Name (ARN) of the application.}

\item{SemanticVersion}{[required] The semantic version of the new version.}

\item{SourceCodeArchiveUrl}{A link to the S3 object that contains the ZIP archive of the source code
for this version of your application.

Maximum size 50 MB}

\item{SourceCodeUrl}{A link to a public repository for the source code of your application,
for example the URL of a specific GitHub commit.}

\item{TemplateBody}{The raw packaged AWS SAM template of your application.}

\item{TemplateUrl}{A link to the packaged AWS SAM template of your application.}
}
\value{
A list with the following syntax:\preformatted{list(
  ApplicationId = "string",
  CreationTime = "string",
  ParameterDefinitions = list(
    list(
      AllowedPattern = "string",
      AllowedValues = list(
        "string"
      ),
      ConstraintDescription = "string",
      DefaultValue = "string",
      Description = "string",
      MaxLength = 123,
      MaxValue = 123,
      MinLength = 123,
      MinValue = 123,
      Name = "string",
      NoEcho = TRUE|FALSE,
      ReferencedByResources = list(
        "string"
      ),
      Type = "string"
    )
  ),
  RequiredCapabilities = list(
    "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"|"CAPABILITY_RESOURCE_POLICY"
  ),
  ResourcesSupported = TRUE|FALSE,
  SemanticVersion = "string",
  SourceCodeArchiveUrl = "string",
  SourceCodeUrl = "string",
  TemplateUrl = "string"
)
}
}
\description{
Creates an application version.
}
\section{Request syntax}{
\preformatted{svc$create_application_version(
  ApplicationId = "string",
  SemanticVersion = "string",
  SourceCodeArchiveUrl = "string",
  SourceCodeUrl = "string",
  TemplateBody = "string",
  TemplateUrl = "string"
)
}
}

\keyword{internal}
