% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_network_interface_attribute}
\alias{ec2_modify_network_interface_attribute}
\title{Modifies the specified network interface attribute}
\usage{
ec2_modify_network_interface_attribute(Attachment, Description, DryRun,
  Groups, NetworkInterfaceId, SourceDestCheck)
}
\arguments{
\item{Attachment}{Information about the interface attachment. If modifying the 'delete on
termination' attribute, you must specify the ID of the interface
attachment.}

\item{Description}{A description for the network interface.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Groups}{Changes the security groups for the network interface. The new set of
groups you specify replaces the current set. You must specify at least
one group, even if it's just the default security group in the VPC. You
must specify the ID of the security group, not the name.}

\item{NetworkInterfaceId}{[required] The ID of the network interface.}

\item{SourceDestCheck}{Indicates whether source/destination checking is enabled. A value of
\code{true} means checking is enabled, and \code{false} means checking is
disabled. This value must be \code{false} for a NAT instance to perform NAT.
For more information, see \href{https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html}{NAT Instances}
in the \emph{Amazon Virtual Private Cloud User Guide}.}
}
\description{
Modifies the specified network interface attribute. You can specify only
one attribute at a time. You can use this action to attach and detach
security groups from an existing EC2 instance.
}
\section{Request syntax}{
\preformatted{svc$modify_network_interface_attribute(
  Attachment = list(
    AttachmentId = "string",
    DeleteOnTermination = TRUE|FALSE
  ),
  Description = list(
    Value = "string"
  ),
  DryRun = TRUE|FALSE,
  Groups = list(
    "string"
  ),
  NetworkInterfaceId = "string",
  SourceDestCheck = list(
    Value = TRUE|FALSE
  )
)
}
}

\examples{
# This example modifies the attachment attribute of the specified network
# interface.
\donttest{svc$modify_network_interface_attribute(
  Attachment = list(
    AttachmentId = "eni-attach-43348162",
    DeleteOnTermination = FALSE
  ),
  NetworkInterfaceId = "eni-686ea200"
)}

# This example modifies the description attribute of the specified network
# interface.
\donttest{svc$modify_network_interface_attribute(
  Description = list(
    Value = "My description"
  ),
  NetworkInterfaceId = "eni-686ea200"
)}

# This example command modifies the groupSet attribute of the specified
# network interface.
\donttest{svc$modify_network_interface_attribute(
  Groups = list(
    "sg-903004f8",
    "sg-1a2b3c4d"
  ),
  NetworkInterfaceId = "eni-686ea200"
)}

# This example command modifies the sourceDestCheck attribute of the
# specified network interface.
\donttest{svc$modify_network_interface_attribute(
  NetworkInterfaceId = "eni-686ea200",
  SourceDestCheck = list(
    Value = FALSE
  )
)}

}
\keyword{internal}
