# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon EC2 Container Registry
#'
#' @description
#' Amazon Elastic Container Registry
#' 
#' Amazon Elastic Container Registry (Amazon ECR) is a managed Docker
#' registry service. Customers can use the familiar Docker CLI to push,
#' pull, and manage images. Amazon ECR provides a secure, scalable, and
#' reliable registry. Amazon ECR supports private Docker repositories with
#' resource-based permissions using IAM so that specific users or Amazon
#' EC2 instances can access repositories and images. Developers can use the
#' Docker CLI to author and manage images.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- ecr(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example deletes images with the tags precise and trusty in a
#' # repository called ubuntu in the default registry for an account.
#' \donttest{svc <- ecr()
#' svc$batch_delete_image(
#'   imageIds = list(
#'     list(
#'       imageTag = "precise"
#'     )
#'   ),
#'   repositoryName = "ubuntu"
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=ecr_batch_check_layer_availability]{batch_check_layer_availability} \tab Check the availability of multiple image layers in a specified registry and repository \cr
#'  \link[=ecr_batch_delete_image]{batch_delete_image} \tab Deletes a list of specified images within a specified repository \cr
#'  \link[=ecr_batch_get_image]{batch_get_image} \tab Gets detailed information for specified images within a specified repository \cr
#'  \link[=ecr_complete_layer_upload]{complete_layer_upload} \tab Informs Amazon ECR that the image layer upload has completed for a specified registry, repository name, and upload ID\cr
#'  \link[=ecr_create_repository]{create_repository} \tab Creates an Amazon Elastic Container Registry (Amazon ECR) repository, where users can push and pull Docker images \cr
#'  \link[=ecr_delete_lifecycle_policy]{delete_lifecycle_policy} \tab Deletes the specified lifecycle policy \cr
#'  \link[=ecr_delete_repository]{delete_repository} \tab Deletes an existing image repository \cr
#'  \link[=ecr_delete_repository_policy]{delete_repository_policy} \tab Deletes the repository policy from a specified repository \cr
#'  \link[=ecr_describe_images]{describe_images} \tab Returns metadata about the images in a repository, including image size, image tags, and creation date \cr
#'  \link[=ecr_describe_image_scan_findings]{describe_image_scan_findings} \tab Describes the image scan findings for the specified image \cr
#'  \link[=ecr_describe_repositories]{describe_repositories} \tab Describes image repositories in a registry \cr
#'  \link[=ecr_get_authorization_token]{get_authorization_token} \tab Retrieves a token that is valid for a specified registry for 12 hours \cr
#'  \link[=ecr_get_download_url_for_layer]{get_download_url_for_layer} \tab Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer \cr
#'  \link[=ecr_get_lifecycle_policy]{get_lifecycle_policy} \tab Retrieves the specified lifecycle policy \cr
#'  \link[=ecr_get_lifecycle_policy_preview]{get_lifecycle_policy_preview} \tab Retrieves the results of the specified lifecycle policy preview request \cr
#'  \link[=ecr_get_repository_policy]{get_repository_policy} \tab Retrieves the repository policy for a specified repository \cr
#'  \link[=ecr_initiate_layer_upload]{initiate_layer_upload} \tab Notify Amazon ECR that you intend to upload an image layer \cr
#'  \link[=ecr_list_images]{list_images} \tab Lists all the image IDs for a given repository \cr
#'  \link[=ecr_list_tags_for_resource]{list_tags_for_resource} \tab List the tags for an Amazon ECR resource \cr
#'  \link[=ecr_put_image]{put_image} \tab Creates or updates the image manifest and tags associated with an image \cr
#'  \link[=ecr_put_image_scanning_configuration]{put_image_scanning_configuration} \tab Updates the image scanning configuration for a repository \cr
#'  \link[=ecr_put_image_tag_mutability]{put_image_tag_mutability} \tab Updates the image tag mutability settings for a repository \cr
#'  \link[=ecr_put_lifecycle_policy]{put_lifecycle_policy} \tab Creates or updates a lifecycle policy \cr
#'  \link[=ecr_set_repository_policy]{set_repository_policy} \tab Applies a repository policy on a specified repository to control access permissions \cr
#'  \link[=ecr_start_image_scan]{start_image_scan} \tab Starts an image vulnerability scan \cr
#'  \link[=ecr_start_lifecycle_policy_preview]{start_lifecycle_policy_preview} \tab Starts a preview of the specified lifecycle policy \cr
#'  \link[=ecr_tag_resource]{tag_resource} \tab Adds specified tags to a resource with the specified ARN \cr
#'  \link[=ecr_untag_resource]{untag_resource} \tab Deletes specified tags from a resource \cr
#'  \link[=ecr_upload_layer_part]{upload_layer_part} \tab Uploads an image layer part to Amazon ECR 
#' }
#'
#' @rdname ecr
#' @export
ecr <- function(config = list()) {
  svc <- .ecr$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.ecr <- list()

.ecr$operations <- list()

.ecr$metadata <- list(
  service_name = "ecr",
  endpoints = list("*" = list(endpoint = "ecr.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "ecr.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "ECR",
  api_version = "2015-09-21",
  signing_name = "ecr",
  json_version = "1.1",
  target_prefix = "AmazonEC2ContainerRegistry_V20150921"
)

.ecr$handlers <- new_handlers("jsonrpc", "v4")

.ecr$service <- function(config = list()) {
  new_service(.ecr$metadata, .ecr$handlers, config)
}
