% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_client_vpn_route}
\alias{ec2_create_client_vpn_route}
\title{Adds a route to a network to a Client VPN endpoint}
\usage{
ec2_create_client_vpn_route(ClientVpnEndpointId, DestinationCidrBlock,
  TargetVpcSubnetId, Description, ClientToken, DryRun)
}
\arguments{
\item{ClientVpnEndpointId}{[required] The ID of the Client VPN endpoint to which to add the route.}

\item{DestinationCidrBlock}{[required] The IPv4 address range, in CIDR notation, of the route destination. For
example:
\itemize{
\item To add a route for Internet access, enter \verb{0.0.0.0/0}
\item To add a route for a peered VPC, enter the peered VPC\'s IPv4 CIDR
range
\item To add a route for an on-premises network, enter the AWS
Site-to-Site VPN connection\'s IPv4 CIDR range
}

Route address ranges cannot overlap with the CIDR range specified for
client allocation.}

\item{TargetVpcSubnetId}{[required] The ID of the subnet through which you want to route traffic. The
specified subnet must be an existing target network of the Client VPN
endpoint.}

\item{Description}{A brief description of the route.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Adds a route to a network to a Client VPN endpoint. Each Client VPN
endpoint has a route table that describes the available destination
network routes. Each route in the route table specifies the path for
traï¬ƒc to speciï¬c resources or networks.
}
\section{Request syntax}{
\preformatted{svc$create_client_vpn_route(
  ClientVpnEndpointId = "string",
  DestinationCidrBlock = "string",
  TargetVpcSubnetId = "string",
  Description = "string",
  ClientToken = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
