% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_availability_zone_group}
\alias{ec2_modify_availability_zone_group}
\title{Enables or disables an Availability Zone group for your account}
\usage{
ec2_modify_availability_zone_group(GroupName, OptInStatus, DryRun)
}
\arguments{
\item{GroupName}{[required] The name of the Availability Zone Group.}

\item{OptInStatus}{[required] Indicates whether to enable or disable membership. The valid values are
\verb{opted-in}. You must contact \href{https://console.aws.amazon.com/support/home#/case/create?issueType=customer-service&serviceCode=general-info&getting-started&categoryCode=using-aws&services}{AWS Support}
to disable an Availability Zone group.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Enables or disables an Availability Zone group for your account.
}
\details{
Use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html}{DescribeAvailabilityZones}
to view the value for \code{GroupName}.
}
\section{Request syntax}{
\preformatted{svc$modify_availability_zone_group(
  GroupName = "string",
  OptInStatus = "opted-in"|"not-opted-in",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
