% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_public_ipv_4_pool}
\alias{ec2_create_public_ipv_4_pool}
\title{Creates a public IPv4 address pool}
\usage{
ec2_create_public_ipv_4_pool(DryRun = NULL, TagSpecifications = NULL)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{TagSpecifications}{The key/value combination of a tag assigned to the resource. Use the tag
key in the filter name and the tag value as the filter value. For
example, to find all resources that have a tag with the key \code{Owner} and
the value \code{TeamA}, specify \code{tag:Owner} for the filter name and \code{TeamA}
for the filter value.}
}
\description{
Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only. To monitor the status of pool creation, use \code{\link[=ec2_describe_public_ipv_4_pools]{describe_public_ipv_4_pools}}.

See \url{https://paws-r.github.io/docs/ec2/create_public_ipv_4_pool.html} for full documentation.
}
\keyword{internal}
