% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_traffic_mirror_filters}
\alias{ec2_describe_traffic_mirror_filters}
\title{Describes one or more Traffic Mirror filters}
\usage{
ec2_describe_traffic_mirror_filters(
  TrafficMirrorFilterIds = NULL,
  DryRun = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{TrafficMirrorFilterIds}{The ID of the Traffic Mirror filter.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{One or more filters. The possible values are:
\itemize{
\item \code{description}: The Traffic Mirror filter description.
\item \code{traffic-mirror-filter-id}: The ID of the Traffic Mirror filter.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Describes one or more Traffic Mirror filters.

See \url{https://paws-r.github.io/docs/ec2/describe_traffic_mirror_filters.html} for full documentation.
}
\keyword{internal}
