% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_report_instance_status}
\alias{ec2_report_instance_status}
\title{Submits feedback about the status of an instance}
\usage{
ec2_report_instance_status(
  Description = NULL,
  DryRun = NULL,
  EndTime = NULL,
  Instances,
  ReasonCodes,
  StartTime = NULL,
  Status
)
}
\arguments{
\item{Description}{Descriptive text about the health state of your instance.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{EndTime}{The time at which the reported instance health state ended.}

\item{Instances}{[required] The instances.}

\item{ReasonCodes}{[required] The reason codes that describe the health state of your instance.
\itemize{
\item \verb{instance-stuck-in-state}: My instance is stuck in a state.
\item \code{unresponsive}: My instance is unresponsive.
\item \code{not-accepting-credentials}: My instance is not accepting my
credentials.
\item \code{password-not-available}: A password is not available for my
instance.
\item \code{performance-network}: My instance is experiencing performance
problems that I believe are network related.
\item \code{performance-instance-store}: My instance is experiencing
performance problems that I believe are related to the instance
stores.
\item \code{performance-ebs-volume}: My instance is experiencing performance
problems that I believe are related to an EBS volume.
\item \code{performance-other}: My instance is experiencing performance
problems.
\item \code{other}: [explain using the description parameter]
}}

\item{StartTime}{The time at which the reported instance health state began.}

\item{Status}{[required] The status of all instances listed.}
}
\description{
Submits feedback about the status of an instance. The instance must be in the \code{running} state. If your experience with the instance differs from the instance status returned by \code{\link[=ec2_describe_instance_status]{describe_instance_status}}, use \code{\link[=ec2_report_instance_status]{report_instance_status}} to report your experience with the instance. Amazon EC2 collects this information to improve the accuracy of status checks.

See \url{https://paws-r.github.io/docs/ec2/report_instance_status.html} for full documentation.
}
\keyword{internal}
