% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_update_security_group_rule_descriptions_egress}
\alias{ec2_update_security_group_rule_descriptions_egress}
\title{[VPC only] Updates the description of an egress (outbound)
security group rule}
\usage{
ec2_update_security_group_rule_descriptions_egress(
  DryRun = NULL,
  GroupId = NULL,
  GroupName = NULL,
  IpPermissions = NULL,
  SecurityGroupRuleDescriptions = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{GroupId}{The ID of the security group. You must specify either the security group
ID or the security group name in the request. For security groups in a
nondefault VPC, you must specify the security group ID.}

\item{GroupName}{[Default VPC] The name of the security group. You must specify either
the security group ID or the security group name in the request.}

\item{IpPermissions}{The IP permissions for the security group rule. You must specify either
the IP permissions or the description.}

\item{SecurityGroupRuleDescriptions}{The description for the egress security group rules. You must specify
either the description or the IP permissions.}
}
\description{
[VPC only] Updates the description of an egress (outbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously. You can remove a description for a security group rule by omitting the description parameter in the request.

See \url{https://paws-r.github.io/docs/ec2/update_security_group_rule_descriptions_egress.html} for full documentation.
}
\keyword{internal}
