% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emrcontainers_operations.R
\name{emrcontainers_list_job_runs}
\alias{emrcontainers_list_job_runs}
\title{Lists job runs based on a set of parameters}
\usage{
emrcontainers_list_job_runs(
  virtualClusterId,
  createdBefore = NULL,
  createdAfter = NULL,
  name = NULL,
  states = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{virtualClusterId}{[required] The ID of the virtual cluster for which to list the job run.}

\item{createdBefore}{The date and time before which the job runs were submitted.}

\item{createdAfter}{The date and time after which the job runs were submitted.}

\item{name}{The name of the job run.}

\item{states}{The states of the job run.}

\item{maxResults}{The maximum number of job runs that can be listed.}

\item{nextToken}{The token for the next set of job runs to return.}
}
\description{
Lists job runs based on a set of parameters. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.

See \url{https://paws-r.github.io/docs/emrcontainers/list_job_runs.html} for full documentation.
}
\keyword{internal}
