% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emrcontainers_operations.R
\name{emrcontainers_start_job_run}
\alias{emrcontainers_start_job_run}
\title{Starts a job run}
\usage{
emrcontainers_start_job_run(
  name = NULL,
  virtualClusterId,
  clientToken,
  executionRoleArn,
  releaseLabel,
  jobDriver,
  configurationOverrides = NULL,
  tags = NULL
)
}
\arguments{
\item{name}{The name of the job run.}

\item{virtualClusterId}{[required] The virtual cluster ID for which the job run request is submitted.}

\item{clientToken}{[required] The client idempotency token of the job run request.}

\item{executionRoleArn}{[required] The execution role ARN for the job run.}

\item{releaseLabel}{[required] The Amazon EMR release version to use for the job run.}

\item{jobDriver}{[required] The job driver for the job run.}

\item{configurationOverrides}{The configuration overrides for the job run.}

\item{tags}{The tags assigned to job runs.}
}
\description{
Starts a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.

See \url{https://paws-r.github.io/docs/emrcontainers/start_job_run.html} for full documentation.
}
\keyword{internal}
