% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_relational_database_from_snapshot}
\alias{lightsail_create_relational_database_from_snapshot}
\title{Creates a new database from an existing database snapshot in Amazon
Lightsail}
\usage{
lightsail_create_relational_database_from_snapshot(
  relationalDatabaseName,
  availabilityZone = NULL,
  publiclyAccessible = NULL,
  relationalDatabaseSnapshotName = NULL,
  relationalDatabaseBundleId = NULL,
  sourceRelationalDatabaseName = NULL,
  restoreTime = NULL,
  useLatestRestorableTime = NULL,
  tags = NULL
)
}
\arguments{
\item{relationalDatabaseName}{[required] The name to use for your new Lightsail database resource.

Constraints:
\itemize{
\item Must contain from 2 to 255 alphanumeric characters, or hyphens.
\item The first and last character must be a letter or number.
}}

\item{availabilityZone}{The Availability Zone in which to create your new database. Use the
\verb{us-east-2a} case-sensitive format.

You can get a list of Availability Zones by using the \verb{get regions}
operation. Be sure to add the
\verb{include relational database Availability Zones} parameter to your
request.}

\item{publiclyAccessible}{Specifies the accessibility options for your new database. A value of
\code{true} specifies a database that is available to resources outside of
your Lightsail account. A value of \code{false} specifies a database that is
available only to your Lightsail resources in the same region as your
database.}

\item{relationalDatabaseSnapshotName}{The name of the database snapshot from which to create your new
database.}

\item{relationalDatabaseBundleId}{The bundle ID for your new database. A bundle describes the performance
specifications for your database.

You can get a list of database bundle IDs by using the
\verb{get relational database bundles} operation.

When creating a new database from a snapshot, you cannot choose a bundle
that is smaller than the bundle of the source database.}

\item{sourceRelationalDatabaseName}{The name of the source database.}

\item{restoreTime}{The date and time to restore your database from.

Constraints:
\itemize{
\item Must be before the latest restorable time for the database.
\item Cannot be specified if the \verb{use latest restorable time} parameter is
\code{true}.
\item Specified in Coordinated Universal Time (UTC).
\item Specified in the Unix time format.

For example, if you wish to use a restore time of October 1, 2018,
at 8 PM UTC, then you input \code{1538424000} as the restore time.
}}

\item{useLatestRestorableTime}{Specifies whether your database is restored from the latest backup time.
A value of \code{true} restores from the latest backup time.

Default: \code{false}

Constraints: Cannot be specified if the \verb{restore time} parameter is
provided.}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag a
resource after it's created.}
}
\description{
Creates a new database from an existing database snapshot in Amazon Lightsail.

See \url{https://paws-r.github.io/docs/lightsail/create_relational_database_from_snapshot.html} for full documentation.
}
\keyword{internal}
