% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serverlessapplicationrepository_operations.R
\name{serverlessapplicationrepository_create_application}
\alias{serverlessapplicationrepository_create_application}
\title{Creates an application, optionally including an AWS SAM file to create
the first application version in the same call}
\usage{
serverlessapplicationrepository_create_application(
  Author,
  Description,
  HomePageUrl = NULL,
  Labels = NULL,
  LicenseBody = NULL,
  LicenseUrl = NULL,
  Name,
  ReadmeBody = NULL,
  ReadmeUrl = NULL,
  SemanticVersion = NULL,
  SourceCodeArchiveUrl = NULL,
  SourceCodeUrl = NULL,
  SpdxLicenseId = NULL,
  TemplateBody = NULL,
  TemplateUrl = NULL
)
}
\arguments{
\item{Author}{[required] The name of the author publishing the app.

Minimum length=1. Maximum length=127.

Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";}

\item{Description}{[required] The description of the application.

Minimum length=1. Maximum length=256}

\item{HomePageUrl}{A URL with more information about the application, for example the
location of your GitHub repository for the application.}

\item{Labels}{Labels to improve discovery of apps in search results.

Minimum length=1. Maximum length=127. Maximum number of labels: 10

Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";}

\item{LicenseBody}{A local text file that contains the license of the app that matches the
spdxLicenseID value of your application. The file has the format
file://\<path\>/\<filename\>.

Maximum size 5 MB

You can specify only one of licenseBody and licenseUrl; otherwise, an
error results.}

\item{LicenseUrl}{A link to the S3 object that contains the license of the app that
matches the spdxLicenseID value of your application.

Maximum size 5 MB

You can specify only one of licenseBody and licenseUrl; otherwise, an
error results.}

\item{Name}{[required] The name of the application that you want to publish.

Minimum length=1. Maximum length=140

Pattern: "[a-zA-Z0-9\\-]+";}

\item{ReadmeBody}{A local text readme file in Markdown language that contains a more
detailed description of the application and how it works. The file has
the format file://\<path\>/\<filename\>.

Maximum size 5 MB

You can specify only one of readmeBody and readmeUrl; otherwise, an
error results.}

\item{ReadmeUrl}{A link to the S3 object in Markdown language that contains a more
detailed description of the application and how it works.

Maximum size 5 MB

You can specify only one of readmeBody and readmeUrl; otherwise, an
error results.}

\item{SemanticVersion}{The semantic version of the application:

\url{https://semver.org/}}

\item{SourceCodeArchiveUrl}{A link to the S3 object that contains the ZIP archive of the source code
for this version of your application.

Maximum size 50 MB}

\item{SourceCodeUrl}{A link to a public repository for the source code of your application,
for example the URL of a specific GitHub commit.}

\item{SpdxLicenseId}{A valid identifier from \url{https://spdx.org/licenses/}.}

\item{TemplateBody}{The local raw packaged AWS SAM template file of your application. The
file has the format file://\<path\>/\<filename\>.

You can specify only one of templateBody and templateUrl; otherwise an
error results.}

\item{TemplateUrl}{A link to the S3 object containing the packaged AWS SAM template of your
application.

You can specify only one of templateBody and templateUrl; otherwise an
error results.}
}
\description{
Creates an application, optionally including an AWS SAM file to create the first application version in the same call.

See \url{https://paws-r.github.io/docs/serverlessapplicationrepository/create_application.html} for full documentation.
}
\keyword{internal}
