% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_allocate_hosts}
\alias{ec2_allocate_hosts}
\title{Allocates a Dedicated Host to your account}
\usage{
ec2_allocate_hosts(
  AutoPlacement = NULL,
  AvailabilityZone,
  ClientToken = NULL,
  InstanceType = NULL,
  InstanceFamily = NULL,
  Quantity,
  TagSpecifications = NULL,
  HostRecovery = NULL,
  OutpostArn = NULL,
  HostMaintenance = NULL
)
}
\arguments{
\item{AutoPlacement}{Indicates whether the host accepts any untargeted instance launches that
match its instance type configuration, or if it only accepts Host
tenancy instance launches that specify its unique host ID. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding}{Understanding auto-placement and affinity}
in the \emph{Amazon EC2 User Guide}.

Default: \code{on}}

\item{AvailabilityZone}{[required] The Availability Zone in which to allocate the Dedicated Host.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{InstanceType}{Specifies the instance type to be supported by the Dedicated Hosts. If
you specify an instance type, the Dedicated Hosts support instances of
the specified instance type only.

If you want the Dedicated Hosts to support multiple instance types in a
specific instance family, omit this parameter and specify
\strong{InstanceFamily} instead. You cannot specify \strong{InstanceType} and
\strong{InstanceFamily} in the same request.}

\item{InstanceFamily}{Specifies the instance family to be supported by the Dedicated Hosts. If
you specify an instance family, the Dedicated Hosts support multiple
instance types within that instance family.

If you want the Dedicated Hosts to support a specific instance type
only, omit this parameter and specify \strong{InstanceType} instead. You
cannot specify \strong{InstanceFamily} and \strong{InstanceType} in the same
request.}

\item{Quantity}{[required] The number of Dedicated Hosts to allocate to your account with these
parameters.}

\item{TagSpecifications}{The tags to apply to the Dedicated Host during creation.}

\item{HostRecovery}{Indicates whether to enable or disable host recovery for the Dedicated
Host. Host recovery is disabled by default. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html}{Host recovery}
in the \emph{Amazon EC2 User Guide}.

Default: \code{off}}

\item{OutpostArn}{The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on
which to allocate the Dedicated Host.}

\item{HostMaintenance}{Indicates whether to enable or disable host maintenance for the
Dedicated Host. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html}{Host maintenance}
in the \emph{Amazon EC2 User Guide}.}
}
\description{
Allocates a Dedicated Host to your account. At a minimum, specify the supported instance type or instance family, the Availability Zone in which to allocate the host, and the number of hosts to allocate.

See \url{https://www.paws-r-sdk.com/docs/ec2_allocate_hosts/} for full documentation.
}
\keyword{internal}
