% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_capacity_reservations}
\alias{ec2_describe_capacity_reservations}
\title{Describes one or more of your Capacity Reservations}
\usage{
ec2_describe_capacity_reservations(
  CapacityReservationIds = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  Filters = NULL,
  DryRun = NULL
)
}
\arguments{
\item{CapacityReservationIds}{The ID of the Capacity Reservation.}

\item{NextToken}{The token to use to retrieve the next page of results.}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the returned \code{nextToken} value. This value can be between 5 and 500. If
\code{maxResults} is given a larger value than 500, you receive an error.}

\item{Filters}{One or more filters.
\itemize{
\item \code{instance-type} - The type of instance for which the Capacity
Reservation reserves capacity.
\item \code{owner-id} - The ID of the Amazon Web Services account that owns the
Capacity Reservation.
\item \code{instance-platform} - The type of operating system for which the
Capacity Reservation reserves capacity.
\item \code{availability-zone} - The Availability Zone of the Capacity
Reservation.
\item \code{tenancy} - Indicates the tenancy of the Capacity Reservation. A
Capacity Reservation can have one of the following tenancy settings:
\itemize{
\item \code{default} - The Capacity Reservation is created on hardware that
is shared with other Amazon Web Services accounts.
\item \code{dedicated} - The Capacity Reservation is created on
single-tenant hardware that is dedicated to a single Amazon Web
Services account.
}
\item \code{outpost-arn} - The Amazon Resource Name (ARN) of the Outpost on
which the Capacity Reservation was created.
\item \code{state} - The current state of the Capacity Reservation. A Capacity
Reservation can be in one of the following states:
\itemize{
\item \code{active}- The Capacity Reservation is active and the capacity is
available for your use.
\item \code{expired} - The Capacity Reservation expired automatically at
the date and time specified in your request. The reserved
capacity is no longer available for your use.
\item \code{cancelled} - The Capacity Reservation was cancelled. The
reserved capacity is no longer available for your use.
\item \code{pending} - The Capacity Reservation request was successful but
the capacity provisioning is still pending.
\item \code{failed} - The Capacity Reservation request has failed. A
request might fail due to invalid request parameters, capacity
constraints, or instance limit constraints. Failed requests are
retained for 60 minutes.
}
\item \code{start-date} - The date and time at which the Capacity Reservation
was started.
\item \code{end-date} - The date and time at which the Capacity Reservation
expires. When a Capacity Reservation expires, the reserved capacity
is released and you can no longer launch instances into it. The
Capacity Reservation's state changes to expired when it reaches its
end date and time.
\item \code{end-date-type} - Indicates the way in which the Capacity
Reservation ends. A Capacity Reservation can have one of the
following end types:
\itemize{
\item \code{unlimited} - The Capacity Reservation remains active until you
explicitly cancel it.
\item \code{limited} - The Capacity Reservation expires automatically at a
specified date and time.
}
\item \code{instance-match-criteria} - Indicates the type of instance launches
that the Capacity Reservation accepts. The options include:
\itemize{
\item \code{open} - The Capacity Reservation accepts all instances that
have matching attributes (instance type, platform, and
Availability Zone). Instances that have matching attributes
launch into the Capacity Reservation automatically without
specifying any additional parameters.
\item \code{targeted} - The Capacity Reservation only accepts instances
that have matching attributes (instance type, platform, and
Availability Zone), and explicitly target the Capacity
Reservation. This ensures that only permitted instances can use
the reserved capacity.
}
\item \code{placement-group-arn} - The ARN of the cluster placement group in
which the Capacity Reservation was created.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes one or more of your Capacity Reservations. The results describe only the Capacity Reservations in the Amazon Web Services Region that you're currently using.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_capacity_reservations/} for full documentation.
}
\keyword{internal}
