% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_create_alias}
\alias{lambda_create_alias}
\title{Creates an alias for a Lambda function version}
\usage{
lambda_create_alias(
  FunctionName,
  Name,
  FunctionVersion,
  Description = NULL,
  RoutingConfig = NULL
)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Partial ARN} - \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Name}{[required] The name of the alias.}

\item{FunctionVersion}{[required] The function version that the alias invokes.}

\item{Description}{A description of the alias.}

\item{RoutingConfig}{The \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html#configuring-alias-routing}{routing configuration}
of the alias.}
}
\description{
Creates an \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html}{alias} for a Lambda function version. Use aliases to provide clients with a function identifier that you can update to invoke a different version.

See \url{https://www.paws-r-sdk.com/docs/lambda_create_alias/} for full documentation.
}
\keyword{internal}
